<?php
/**
 * Uninstall script for CC Email Manager for WooCommerce.
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Respect user setting for data removal
$aisp_cc_remove_data = get_option( 'aisp_cc_email_remove_data_on_uninstall' );

if ( 'yes' !== $aisp_cc_remove_data ) {
	return;
}

// Delete plugin option
delete_option( 'aisp_cc_email_remove_data_on_uninstall' );

// phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery
// phpcs:disable WordPress.DB.DirectDatabaseQuery.NoCaching

global $wpdb;

// Meta keys to delete (prefixed variable to satisfy WP-CS)
$aisp_cc_meta_keys = array(
	'cc_email_1',
	'cc_email_2',
	'cc_email_1_statuses',
	'cc_email_2_statuses',
);

// Delete all occurrences of each meta key
$aisp_cc_meta_keys = array(
	'cc_email_1',
	'cc_email_2',
	'cc_email_1_statuses',
	'cc_email_2_statuses',
);

// Delete all occurrences of each meta key
foreach ( $aisp_cc_meta_keys as $aisp_cc_meta_key ) {
	$wpdb->query(
		$wpdb->prepare(
			"DELETE FROM {$wpdb->usermeta} WHERE meta_key = %s",
			$aisp_cc_meta_key
		)
	);
}



// phpcs:enable
