<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Add a "CC Email" column in the WordPress Users admin table.
 * With CC1 / CC2 labels.
 */
class AISP_CCEmail_User_Column {

    public function __construct() {

        // Add column
        add_filter( 'manage_users_columns', array( $this, 'add_ccemail_column' ) );

        // Populate column
        add_filter( 'manage_users_custom_column', array( $this, 'render_ccemail_column' ), 10, 3 );

        // Make sortable
        add_filter( 'manage_users_sortable_columns', array( $this, 'make_column_sortable' ) );
    }

    /**
     * Add the new CC Email column.
     */
    public function add_ccemail_column( $columns ) {
        $columns['aisp_cc_email'] = __( 'CC Email', 'aisp-cc-email-manager' );
        return $columns;
    }

    /**
     * Display CC1 + CC2 with labels in the same column.
     */
    public function render_ccemail_column( $value, $column_name, $user_id ) {

        if ( 'aisp_cc_email' === $column_name ) {

            // Replace with your real meta keys if needed
            $cc1 = get_user_meta( $user_id, 'cc_email_1', true );
            $cc2 = get_user_meta( $user_id, 'cc_email_2', true );

            // Nothing stored
            if ( empty( $cc1 ) && empty( $cc2 ) ) {
                return '—';
            }

            $output = '';

            if ( ! empty( $cc1 ) ) {
                $output .= '<strong>CC1:</strong> ' . esc_html( $cc1 );
            }

            if ( ! empty( $cc2 ) ) {
                if ( ! empty( $output ) ) {
                    $output .= '<br>';
                }
                $output .= '<strong>CC2:</strong> ' . esc_html( $cc2 );
            }

            return $output;
        }

        return $value;
    }

    /**
     * Make the column sortable (using CC1 meta).
     */
    public function make_column_sortable( $columns ) {
        $columns['aisp_cc_email'] = 'cc_email_1';
        return $columns;
    }
}

new AISP_CCEmail_User_Column();
