<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class AISP_CC_Email_User_Fields {

    public function __construct() {
        add_action( 'show_user_profile', [ $this, 'render_fields' ] );
        add_action( 'edit_user_profile', [ $this, 'render_fields' ] );

        add_action( 'personal_options_update', [ $this, 'save_fields' ] );
        add_action( 'edit_user_profile_update', [ $this, 'save_fields' ] );
    }


    /**
     * RENDER USER FIELDS IN PROFILE
     */
    public function render_fields( $user ) {

        
        if ( ! in_array( 'customer', (array) $user->roles, true ) ) {
            return;
        }

        $email1      = get_user_meta( $user->ID, 'cc_email_1', true );
        $statuses1   = (array) get_user_meta( $user->ID, 'cc_email_1_statuses', true );

        $email2      = get_user_meta( $user->ID, 'cc_email_2', true );
        $statuses2   = (array) get_user_meta( $user->ID, 'cc_email_2_statuses', true );

        $wc_statuses = wc_get_order_statuses();
		
		foreach ( $wc_statuses as $status_key => $label ) {
			if ( strpos( $status_key, 'draft' ) !== false ) {
				unset( $wc_statuses[ $status_key ] );
			}
		}
		
        ?>

        <h2><?php esc_html_e( 'CC Email Settings', 'aisp-cc-email-manager' ); ?></h2>

        <table class="form-table">

            <!-- CC EMAIL 1 -->
            <tr>
                <th><label for="cc_email_1"><?php esc_html_e( 'CC Email 1', 'aisp-cc-email-manager' ); ?></label></th>
                <td>
                    <input type="email" name="cc_email_1" id="cc_email_1"
                           value="<?php echo esc_attr( $email1 ); ?>" class="regular-text" />
                </td>
            </tr>

            <tr>
                <th><?php esc_html_e( 'Send CC Email 1 for Statuses', 'aisp-cc-email-manager' ); ?></th>
                <td>
                    <?php foreach ( $wc_statuses as $key => $label ) : ?>
                        <label style="display:block;">
                            <input type="checkbox"
                                   name="cc_email_1_statuses[]"
                                   value="<?php echo esc_attr( $key ); ?>"
                                   <?php checked( in_array( $key, $statuses1, true ) ); ?> />
                            <?php echo esc_html( $label ); ?>
                        </label>
                    <?php endforeach; ?>
                </td>
            </tr>


            <!-- CC EMAIL 2 -->
            <tr>
                <th><label for="cc_email_2"><?php esc_html_e( 'CC Email 2', 'aisp-cc-email-manager' ); ?></label></th>
                <td>
                    <input type="email" name="cc_email_2" id="cc_email_2"
                           value="<?php echo esc_attr( $email2 ); ?>" class="regular-text" />

                    <p class="description">
                        <?php esc_html_e( 'If no email is entered here, CC Email 2 settings will remain hidden.', 'aisp-cc-email-manager' ); ?>
                    </p>
                </td>
            </tr>

            <tr id="cc-email-2-statuses-row" style="<?php echo empty( $email2 ) ? 'display:none;' : ''; ?>">
                <th><?php esc_html_e( 'Send CC Email 2 for Statuses', 'aisp-cc-email-manager' ); ?></th>
                <td>
                    <?php foreach ( $wc_statuses as $key => $label ) : ?>
                        <label style="display:block;">
                            <input type="checkbox"
                                   name="cc_email_2_statuses[]"
                                   value="<?php echo esc_attr( $key ); ?>"
                                   <?php checked( in_array( $key, $statuses2, true ) ); ?> />
                            <?php echo esc_html( $label ); ?>
                        </label>
                    <?php endforeach; ?>
                </td>
            </tr>

        </table>

        <?php wp_nonce_field( 'aisp_cc_email_save', 'aisp_cc_email_nonce' ); ?>

        <!-- JS that shows/hides CC Email 2 statuses -->
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const email2Field = document.getElementById('cc_email_2');
                const row2        = document.getElementById('cc-email-2-statuses-row');

                function updateVisibility() {
                    row2.style.display = email2Field.value.trim() === '' ? 'none' : 'table-row';
                }

                email2Field.addEventListener('input', updateVisibility);
                updateVisibility();
            });
        </script>

        <?php
    }


    /**
     * SAVE USER FIELDS
     */
    public function save_fields( $user_id ) {

        if ( ! current_user_can( 'edit_user', $user_id ) ) {
            return;
        }

        
        if ( ! isset( $_POST['aisp_cc_email_nonce'] ) || 
             ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['aisp_cc_email_nonce'] ) ), 'aisp_cc_email_save' ) ) {
            return;
        }

        // ========== CC EMAIL 1 ==========
        if ( ! empty( $_POST['cc_email_1'] ) ) {
            update_user_meta( 
                $user_id, 
                'cc_email_1', 
                sanitize_email( wp_unslash( $_POST['cc_email_1'] ) ) 
            );
        } else {
            delete_user_meta( $user_id, 'cc_email_1' );
        }

        if ( ! empty( $_POST['cc_email_1_statuses'] ) ) {
            update_user_meta( 
                $user_id, 
                'cc_email_1_statuses', 
                array_map( 'sanitize_text_field', (array) wp_unslash( $_POST['cc_email_1_statuses'] ) ) 
            );
        } else {
            delete_user_meta( $user_id, 'cc_email_1_statuses' );
        }


        // ========== CC EMAIL 2 ==========
        if ( ! empty( $_POST['cc_email_2'] ) ) {
            update_user_meta( 
                $user_id, 
                'cc_email_2', 
                sanitize_email( wp_unslash( $_POST['cc_email_2'] ) ) 
            );
        } else {
            delete_user_meta( $user_id, 'cc_email_2' );
            delete_user_meta( $user_id, 'cc_email_2_statuses' );
        }

        if ( ! empty( $_POST['cc_email_2_statuses'] ) ) {
            update_user_meta( 
                $user_id, 
                'cc_email_2_statuses', 
                array_map( 'sanitize_text_field', (array) wp_unslash( $_POST['cc_email_2_statuses'] ) ) 
            );
        } else {
            delete_user_meta( $user_id, 'cc_email_2_statuses' );
        }
    }

}
