<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * ================================
 * REGISTER SETTINGS PAGE
 * ================================
 */
add_action( 'admin_menu', 'aisp_cc_email_register_settings_page' );
function aisp_cc_email_register_settings_page() {
	add_options_page(
		__( 'CC Email Manager Settings', 'aisp-cc-email-manager' ),
		__( 'CC Email Manager', 'aisp-cc-email-manager' ),
		'manage_options',
		'aisp-cc-email-settings',
		'aisp_cc_email_render_settings_page'
	);
}

/**
 * ================================
 * REGISTER SETTING (uninstall flag)
 * ================================
 */
add_action(
	'admin_init',
	function() {
		register_setting(
			'aisp_cc_email_settings_group',
			'aisp_cc_email_remove_data_on_uninstall',
			array(
				'sanitize_callback' => 'aisp_cc_email_sanitize_yesno',
			)
		);
	}
);

/**
 * Sanitize "yes" / "no".
 *
 * @param mixed $value Raw input.
 * @return string Sanitized "yes" or "no".
 */
function aisp_cc_email_sanitize_yesno( $value ) {
	return ( 'yes' === $value ) ? 'yes' : 'no';
}

/**
 * ================================
 * SETTINGS PAGE RENDER
 * ================================
 */
function aisp_cc_email_render_settings_page() {

	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}

	$wc_statuses = function_exists( 'wc_get_order_statuses' ) ? wc_get_order_statuses() : array();

	?>
	<div class="wrap">
		<h1><?php esc_html_e( 'CC Email Manager Settings', 'aisp-cc-email-manager' ); ?></h1>

		<!-- ======================================= -->
		<!-- GENERAL SETTINGS -->
		<!-- ======================================= -->
		<h2><?php esc_html_e( 'General Settings', 'aisp-cc-email-manager' ); ?></h2>

		<form method="post" action="options.php">
			<?php
			settings_fields( 'aisp_cc_email_settings_group' );
			do_settings_sections( 'aisp_cc_email_settings_group' );
			?>

			<table class="form-table" role="presentation">
				<tr>
					<th scope="row">
						<?php esc_html_e( 'Remove all data on uninstall', 'aisp-cc-email-manager' ); ?>
					</th>
					<td>
						<label>
							<input type="checkbox"
								   name="aisp_cc_email_remove_data_on_uninstall"
								   value="yes"
								   <?php checked( get_option( 'aisp_cc_email_remove_data_on_uninstall' ), 'yes' ); ?> />
							<?php esc_html_e( 'Delete all plugin data when the plugin is removed.', 'aisp-cc-email-manager' ); ?>
						</label>
					</td>
				</tr>
			</table>
		<p class="description">
			<?php esc_html_e( 'Note: WooCommerce does not send any native email for the "pending" status. CC emails will only be sent if a third-party plugin triggers an email for this status (e.g., Order Tools).', 'aisp-cc-email-manager' ); ?>
		</p>

			<?php submit_button(); ?>
		</form>

		<hr />

		<!-- ======================================= -->
		<!-- TOOLS -->
		<!-- ======================================= -->
		<h2><?php esc_html_e( 'Tools', 'aisp-cc-email-manager' ); ?></h2>

		<form method="post" enctype="multipart/form-data">
			<?php wp_nonce_field( 'aisp_cc_email_tools', 'aisp_cc_email_tools_nonce' ); ?>

			<!-- ======================================= -->
			<!-- BULK EMAIL & STATUS UPDATE (COMBINED) -->
			<!-- ======================================= -->

			<h3><?php esc_html_e( 'Bulk Email & Status Update (CC1 + CC2)', 'aisp-cc-email-manager' ); ?></h3>

			<p>
				<?php esc_html_e(
					'Update all users that use a specific CC email in CC Email 1 or CC Email 2.',
					'aisp-cc-email-manager'
				); ?>
				<br />
				<?php esc_html_e(
					'If "New email" is provided, the email will be replaced. If statuses are selected, they will be added and/or removed.',
					'aisp-cc-email-manager'
				); ?>
				<br />
				<?php esc_html_e(
					'You can change the email, the statuses, or both at the same time.',
					'aisp-cc-email-manager'
				); ?>
			</p>

			<table class="form-table" role="presentation">
				<tr>
					<th scope="row"><?php esc_html_e( 'Email (required)', 'aisp-cc-email-manager' ); ?></th>
					<td>
						<input type="email" name="aisp_cc_email_bulk_old" class="regular-text" required />
						<p class="description">
							<?php esc_html_e( 'This email will be searched in CC Email 1 and CC Email 2.', 'aisp-cc-email-manager' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row"><?php esc_html_e( 'Email remplacement (optional)', 'aisp-cc-email-manager' ); ?></th>
					<td>
						<input type="email" name="aisp_cc_email_bulk_new" class="regular-text" />
						<p class="description">
							<?php esc_html_e( 'Leave empty if you only want to update statuses for the existing email.', 'aisp-cc-email-manager' ); ?>
						</p>
					</td>
				</tr>

				<?php if ( ! empty( $wc_statuses ) ) : ?>
					<tr>
						<th scope="row">
							<?php esc_html_e( 'Statuses to add', 'aisp-cc-email-manager' ); ?>
						</th>
						<td>
							<?php foreach ( $wc_statuses as $status_key => $status_label ) : ?>
								<label style="display:block;">
									<input type="checkbox"
										name="aisp_cc_email_status_add[]"
										value="<?php echo esc_attr( $status_key ); ?>" />
									<?php echo esc_html( $status_label ); ?>
								</label>
							<?php endforeach; ?>
							<p class="description">
								<?php esc_html_e( 'These statuses will be added to the current configuration for this email, if not already present.', 'aisp-cc-email-manager' ); ?>
							</p>
						</td>
					</tr>

					<tr>
						<th scope="row">
							<?php esc_html_e( 'Statuses to remove', 'aisp-cc-email-manager' ); ?>
						</th>
						<td>
							<?php foreach ( $wc_statuses as $status_key => $status_label ) : ?>
								<label style="display:block;">
									<input type="checkbox"
										name="aisp_cc_email_status_remove[]"
										value="<?php echo esc_attr( $status_key ); ?>" />
									<?php echo esc_html( $status_label ); ?>
								</label>
							<?php endforeach; ?>
							<p class="description">
								<?php esc_html_e( 'These statuses will be removed from the current configuration for this email.', 'aisp-cc-email-manager' ); ?>
							</p>
						</td>
					</tr>
				<?php else : ?>
					<tr>
						<th scope="row"><?php esc_html_e( 'Order statuses', 'aisp-cc-email-manager' ); ?></th>
						<td>
							<p class="description">
								<?php esc_html_e( 'WooCommerce order statuses could not be loaded.', 'aisp-cc-email-manager' ); ?>
							</p>
						</td>
					</tr>
				<?php endif; ?>
			</table>

			<?php
			submit_button(
				__( 'Run Bulk Email & Status Update', 'aisp-cc-email-manager' ),
				'secondary',
				'aisp_cc_email_bulk_replace_submit'
			);
			
			?>

			<hr />

			<!-- ======================================= -->
			<!-- CLEAR ALL CC -->
			<!-- ======================================= -->

			<h3><?php esc_html_e( 'Clear ALL CC Data', 'aisp-cc-email-manager' ); ?></h3>
			<p><?php esc_html_e( 'This will delete CC Email 1, CC Email 2, and all related status selections for ALL users.', 'aisp-cc-email-manager' ); ?></p>

			<?php
			submit_button(
				__( 'Clear All CC Data', 'aisp-cc-email-manager' ),
				'delete',
				'aisp_cc_email_clear_all_cc',
				false
			);
			?>

			<hr />

			<!-- ======================================= -->
			<!-- IMPORT CSV -->
			<!-- ======================================= -->

			<h3><?php esc_html_e( 'Import CC Data (CSV)', 'aisp-cc-email-manager' ); ?></h3>

			<p>
				<?php esc_html_e( 'Upload a CSV with columns:', 'aisp-cc-email-manager' ); ?><br />
				<code>user_id, user_email, cc_email_1, cc_email_2, cc_email_1_statuses, cc_email_2_statuses</code><br />
				<?php esc_html_e( 'Statuses must be comma-separated, e.g.: wc-pending,wc-processing', 'aisp-cc-email-manager' ); ?>
			</p>

			<input type="file" name="aisp_cc_email_import_file" accept=".csv" />
			<?php submit_button( __( 'Import CSV', 'aisp-cc-email-manager' ), 'secondary', 'aisp_cc_email_import_submit' ); ?>

		</form>

		<hr />

		<!-- ======================================= -->
		<!-- EXPORT CSV -->
		<!-- ======================================= -->
		<h3><?php esc_html_e( 'Export CC Data (CSV)', 'aisp-cc-email-manager' ); ?></h3>
		<p><?php esc_html_e( 'Download a CSV file containing all users with CC data.', 'aisp-cc-email-manager' ); ?></p>

		<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
			<?php wp_nonce_field( 'aisp_cc_email_export', 'aisp_cc_email_export_nonce' ); ?>
			<input type="hidden" name="action" value="aisp_cc_email_export" />
			<?php submit_button( __( 'Export CSV', 'aisp-cc-email-manager' ), 'secondary' ); ?>
		</form>

	</div>
	<?php
}
