<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class AISP_CC_Email_Hooks {

    public function __construct() {
        add_filter( 'woocommerce_email_headers', array( $this, 'inject_cc' ), 10, 3 );
    }

    /**
     * Inject CC recipients into WooCommerce outgoing emails.
     *
     * @param string   $headers  Email headers.
     * @param string   $email_id WooCommerce email ID.
     * @param WC_Order $order    Order object.
     *
     * @return string Updated headers.
     */
    public function inject_cc( $headers, $email_id, $order ) {

        
        if ( ! $order instanceof WC_Order ) {
            return $headers;
        }

        $user_id = $order->get_user_id();

        
        if ( ! $user_id ) {
            return $headers;
        }

        
        if ( strpos( $email_id, 'admin' ) !== false ) {
            return $headers;
        }

        
        $cc1_raw       = get_user_meta( $user_id, 'cc_email_1', true );
        $statuses1_raw = get_user_meta( $user_id, 'cc_email_1_statuses', true );

        $cc2_raw       = get_user_meta( $user_id, 'cc_email_2', true );
        $statuses2_raw = get_user_meta( $user_id, 'cc_email_2_statuses', true );

        
        $cc1       = sanitize_email( $cc1_raw );
        $cc2       = sanitize_email( $cc2_raw );
        $statuses1 = is_array( $statuses1_raw ) ? array_map( 'sanitize_text_field', $statuses1_raw ) : array();
        $statuses2 = is_array( $statuses2_raw ) ? array_map( 'sanitize_text_field', $statuses2_raw ) : array();

        
        $current_status = 'wc-' . sanitize_text_field( $order->get_status() );

        // =====================================================
        // CC EMAIL 1 (indépendant de CC2)
        // =====================================================
        if ( ! empty( $cc1 ) && filter_var( $cc1, FILTER_VALIDATE_EMAIL ) ) {

            if ( in_array( $current_status, $statuses1, true ) ) {
                $headers .= 'Cc: ' . $cc1 . "\r\n";
            }
        }

        // =====================================================
        // CC EMAIL 2 (indépendant de CC1 — NOUVELLE LOGIQUE)
        // =====================================================
        if ( ! empty( $cc2 ) && filter_var( $cc2, FILTER_VALIDATE_EMAIL ) ) {

            if ( in_array( $current_status, $statuses2, true ) ) {
                $headers .= 'Cc: ' . $cc2 . "\r\n";
            }
        }

        return $headers;
    }
}
