<?php
/**
 * Plugin Name: CC Email Manager for WooCommerce
 * Plugin URI: https://aispdev.com/cc-email-manager-for-woocommerce/
 * Author URI: https://aispdev.com
 * Description: Adds CC (carbon copy) email addresses per user and automatically sends WooCommerce notifications to these CC recipients based on order status.
 * Version: 1.0.0
 * Author: AISP Dev
 * Text Domain: aisp-cc-email-manager
 * Requires Plugins: woocommerce
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


add_action( 'plugins_loaded', function() {

	// Check WooCommerce activation reliably
	if ( ! class_exists( 'WooCommerce' ) ) {

		// Admin notice (properly prefixed)
		add_action( 'admin_notices', function () {
			?>
			<div class="notice notice-error">
				<p>
					<?php esc_html_e(
						'CC Email Management for WooCommerce requires WooCommerce to be installed and active.',
						'aisp-cc-email-manager'
					); ?>
				</p>
			</div>
			<?php
		});

		return;
	}

	// Load required classes ONLY if WooCommerce is active
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aisp-cc-email-user-fields.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aisp-cc-email-hooks.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aisp-cc-email-tools.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aisp-cc-email-settings-page.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-aisp-cc-email-users-column.php';


	// Initialize plugin classes
	new AISP_CC_Email_User_Fields();
	new AISP_CC_Email_Hooks();
	new AISP_CC_Email_Tools();

});