/**
 * AIRize admin scripts.
 *
 * @package AIRize
 * @version 1.0.0
 */

/* global jQuery, airizeAdmin */
/* global wp */

(function ($) {
	'use strict';

	function activeTab() {
		var $active = $('.nav-tab-wrapper .nav-tab.nav-tab-active');
		return ($active.attr('href') || '#settings').replace('#', '');
	}

	function showTab(tab) {
		$('.nav-tab-wrapper .nav-tab').removeClass('nav-tab-active');
		$('.airize-tab-panel').hide();

		$('.nav-tab-wrapper .nav-tab[href="#' + tab + '"]').addClass('nav-tab-active');
		$('#airize-' + tab + '-content').show();

		if (tab === 'preview') {
			loadPreview();
		}
	}

	function collectPreviewSettings() {
		var preview = {
			providers: {},
			button_text: {},
			provider_icons: {},
			custom_colors: {},
			design_style: $('[name="airize_design_style"]').val() || '',
			button_size: $('[name="airize_button_size"]').val() || '',
			prompt_text: $('[name="airize_prompt_text"]').val() || '',
			intro_text: $('[name="airize_intro_text"]').val() || ''
		};

		$('[name^="airize_providers["]').each(function () {
			var name = $(this).attr('name') || '';
			var match = name.match(/^airize_providers\[(.+)\]$/);
			if (!match) {
				return;
			}
			preview.providers[match[1]] = $(this).is(':checked') ? 1 : 0;
		});

		$('[name^="airize_button_text["]').each(function () {
			var name = $(this).attr('name') || '';
			var match = name.match(/^airize_button_text\[(.+)\]$/);
			if (!match) {
				return;
			}
			preview.button_text[match[1]] = $(this).val();
		});

		$('[name^="airize_custom_colors["]').each(function () {
			var name = $(this).attr('name') || '';
			var match = name.match(/^airize_custom_colors\[(.+)\]$/);
			if (!match) {
				return;
			}
			preview.custom_colors[match[1]] = $(this).val();
		});

		$('[name^="airize_provider_icons["]').each(function () {
			var name = $(this).attr('name') || '';
			var match = name.match(/^airize_provider_icons\[(.+)\]$/);
			if (!match) {
				return;
			}
			preview.provider_icons[match[1]] = $(this).val();
		});

		return preview;
	}

	function setIconPreview(targetId, url) {
		var $row = $('.airize-icon-preview-row[data-target="' + targetId + '"]');
		if (!$row.length) {
			return;
		}

		if (!url) {
			$row.addClass('is-hidden');
			$row.find('img').attr('src', '');
			return;
		}

		$row.find('img').attr('src', url);
		$row.removeClass('is-hidden');
	}

	function renderError($preview) {
		$preview.html('<p>' + (airizeAdmin && airizeAdmin.i18n && airizeAdmin.i18n.error ? airizeAdmin.i18n.error : 'Error') + '</p>');
	}

	function loadPreview() {
		var $preview = $('#airize-buttons-preview');
		if (!$preview.length) {
			return;
		}

		$preview.attr('aria-busy', 'true');

		$.post(airizeAdmin.ajaxUrl, {
			action: 'airize_test_links',
			nonce: airizeAdmin.nonce,
			preview: collectPreviewSettings()
		})
			.done(function (response) {
				if (response && response.success && response.data && typeof response.data.html !== 'undefined') {
					$preview.html(response.data.html);
					return;
				}
				renderError($preview);
			})
			.fail(function () {
				renderError($preview);
			})
			.always(function () {
				$preview.attr('aria-busy', 'false');
			});
	}

	$(function () {
		if (!$('#airize-settings-content').length) {
			return;
		}

		if ($.fn.wpColorPicker) {
			$('.airize-color-field').wpColorPicker();
		}

		$('.nav-tab-wrapper').on('click', '.nav-tab', function (e) {
			e.preventDefault();
			var tab = ($(this).attr('href') || '#settings').replace('#', '');
			showTab(tab);
			window.location.hash = tab;
		});

		$('#airize-refresh-preview').on('click', function (e) {
			e.preventDefault();
			loadPreview();
		});

		var mediaFrame;
		var currentTargetId = '';

		$('#airize-settings-form').on('click', '.airize-icon-select', function (e) {
			e.preventDefault();

			if (typeof wp === 'undefined' || !wp.media) {
				return;
			}

			currentTargetId = $(this).data('target') || '';
			if (!currentTargetId) {
				return;
			}

			if (!mediaFrame) {
				mediaFrame = wp.media({
					title: airizeAdmin && airizeAdmin.i18n && airizeAdmin.i18n.mediaTitle ? airizeAdmin.i18n.mediaTitle : 'Select an icon',
					button: { text: airizeAdmin && airizeAdmin.i18n && airizeAdmin.i18n.mediaButton ? airizeAdmin.i18n.mediaButton : 'Use this icon' },
					library: { type: 'image' },
					multiple: false
				});

				mediaFrame.on('select', function () {
					var selection = mediaFrame.state().get('selection');
					var attachment = selection && selection.first ? selection.first().toJSON() : null;
					if (!attachment || !attachment.url || !currentTargetId) {
						return;
					}

					var $input = $('#' + currentTargetId);
					$input.val(attachment.url).trigger('change');
					setIconPreview(currentTargetId, attachment.url);
				});
			}

			mediaFrame.open();
		});

		$('#airize-settings-form').on('click', '.airize-icon-remove', function (e) {
			e.preventDefault();
			var targetId = $(this).data('target') || '';
			if (!targetId) {
				return;
			}
			var $input = $('#' + targetId);
			$input.val('').trigger('change');
			setIconPreview(targetId, '');
		});

		$('#airize-settings-form').on('input change', '.airize-icon-field', function () {
			var targetId = $(this).attr('id') || '';
			if (!targetId) {
				return;
			}
			setIconPreview(targetId, $(this).val());
		});

		var initialTab = window.location.hash ? window.location.hash.replace('#', '') : 'settings';
		if (!$('#airize-' + initialTab + '-content').length) {
			initialTab = 'settings';
		}
		showTab(initialTab);

		var debounce;
		$('#airize-settings-form').on('input change', ':input', function () {
			if (activeTab() !== 'preview') {
				return;
			}
			clearTimeout(debounce);
			debounce = setTimeout(loadPreview, 250);
		});
	});
})(jQuery);
