<?php
/**
 * Status & Logs Tab View
 *
 * This file renders the page that displays the real-time processing status,
 * maintenance tools, and the detailed activity log of the plugin.
 *
 * @package           AINP_AI_Native_Publisher
 * @author            AI News Publisher
 * @copyright         2025, AI News Publisher
 * @license           GPL-2.0+
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="ainp-wrap">
	<div class="top-section-wrapper">
		<div class="top-section-left">
			<h3><?php esc_html_e( 'Current Fetch Status', 'ainp-ai-native-publisher' ); ?></h3>
			<div id="ainp-status-area" class="status-area-container">
				<div class="status-grid">
					<div class="status-item status-label"><?php esc_html_e( 'Status:', 'ainp-ai-native-publisher' ); ?></div>
					<div class="status-item status-value processing-status">--</div>
					
					<div class="status-item status-label"><?php esc_html_e( 'Progress:', 'ainp-ai-native-publisher' ); ?></div>
					<div class="status-item status-value processing-progress">--</div>
					
					<div class="status-item status-bar">
						<div class="progress-bar-wrapper">
							<div class="progress-bar-inner processing-progress-bar" style="width: 0%;"></div>
						</div>
					</div>
					
					<div class="status-item status-cancel-button">
						<button type="button" id="ainp-cancel-search" class="button button-secondary ainp-cancel-button" style="display:none;">
							<span class="button-text"><?php esc_html_e( 'Cancel', 'ainp-ai-native-publisher' ); ?></span>
							<span class="spinner"></span>
						</button>
					</div>
				</div>
				<div class="status-message-text processing-message">--</div>
			</div>
		</div>

		<div class="top-section-right">
			<h3><?php esc_html_e( 'Maintenance Tools', 'ainp-ai-native-publisher' ); ?></h3>
			<div class="maintenance-actions-container">
				<div class="maintenance-actions-grid">
					<div class="action-item">
						<button type="button" id="ainp-reset-jobs" class="button button-secondary ainp-maintenance-button"><span class="button-text"><?php esc_html_e( 'Reset Jobs', 'ainp-ai-native-publisher' ); ?></span></button>
						<p class="description"><?php esc_html_e( 'Stops running jobs and resets queues.', 'ainp-ai-native-publisher' ); ?></p>
					</div>
					<div class="action-item">
						<button type="button" id="ainp-clear-logs" class="button button-secondary ainp-maintenance-button"><span class="button-text"><?php esc_html_e( 'Clear Logs', 'ainp-ai-native-publisher' ); ?></span></button>
						<p class="description"><?php esc_html_e( 'Deletes the activity history.', 'ainp-ai-native-publisher' ); ?></p>
					</div>
					<div class="action-item">
						<button type="button" id="ainp-reset-status" class="button button-secondary ainp-maintenance-button"><span class="button-text"><?php esc_html_e( 'Reset Status', 'ainp-ai-native-publisher' ); ?></span></button>
						<p class="description"><?php esc_html_e( 'Forces the status to "Idle".', 'ainp-ai-native-publisher' ); ?></p>
					</div>
				</div>
				 <div id="ainp-maintenance-status" class="ainp-ajax-status"></div>
			</div>
		</div>
	</div>

	<div class="log-header">
		<h3><?php esc_html_e( 'Activity History', 'ainp-ai-native-publisher' ); ?></h3>
		<button type="button" id="ainp-copy-log" class="button button-secondary"><span class="dashicons dashicons-admin-page"></span> <?php esc_html_e( 'Copy Log', 'ainp-ai-native-publisher' ); ?></button>
	</div>
	<div id="ainp-status-logs-action-status" class="ainp-ajax-status"></div>
	
	<div id="ainp-log-area">
		<p><?php esc_html_e( 'Loading logs...', 'ainp-ai-native-publisher' ); ?></p>
	</div>
</div>