<?php
/**
 * Modules Tab View
 *
 * Renders the settings page for enabling or disabling the main processing modules
 * of the plugin, such as AI content rewriting, image generation options,
 * watermarking, source credits, and keyword filters. Also includes settings
 * related to the enabled modules (e.g., keyword lists, credit format).
 *
 * @package           AINP_AI_Native_Publisher
 * @author            AI News Publisher
 * @copyright         2025, AI News Publisher
 * @license           GPL-2.0+
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="ainp-modules-header">
	<div>
		<h3><?php esc_html_e( 'Core Processing Modules', 'ainp-ai-native-publisher' ); ?></h3>
		<p><?php esc_html_e( 'Enable or disable the main features of the plugin. Disabling a module skips that processing step.', 'ainp-ai-native-publisher' ); ?></p>
	</div>
</div>

<div class="module-grid">
	<div class="module-card">
		<div class="module-card-inner">
			<h3><?php esc_html_e( 'AI Content Rewrite', 'ainp-ai-native-publisher' ); ?></h3>
			<p class="description"><?php esc_html_e( 'Uses the selected AI provider (Gemini/Groq) to rewrite the fetched content.', 'ainp-ai-native-publisher' ); ?></p>
			<label>
				<input type="checkbox" name="ainp_module_rewrite_content" value="1" <?php checked( ! empty( $this->plugin->options['module_rewrite_content'] ) ); ?>>
				<?php esc_html_e( 'Enable Content Rewriting', 'ainp-ai-native-publisher' ); ?>
			</label>
		</div>
	</div>

	<div class="module-card">
		<div class="module-card-inner">
			<h3><?php esc_html_e( 'AI Title Generation', 'ainp-ai-native-publisher' ); ?></h3>
			<p class="description"><?php esc_html_e( 'Uses the AI to create a new, SEO-optimized title based on the rewritten content.', 'ainp-ai-native-publisher' ); ?></p>
			<label>
				<input type="checkbox" name="ainp_module_generate_title" value="1" <?php checked( ! empty( $this->plugin->options['module_generate_title'] ) ); ?>>
				<?php esc_html_e( 'Enable Title Generation', 'ainp-ai-native-publisher' ); ?>
			</label>
		</div>
	</div>

	<div class="module-card">
		<div class="module-card-inner">
			<h3><?php esc_html_e( 'AI Category Assignment', 'ainp-ai-native-publisher' ); ?></h3>
			<p class="description"><?php esc_html_e( 'Uses the AI to suggest and assign a relevant category to the post.', 'ainp-ai-native-publisher' ); ?></p>
			<label>
				<input type="checkbox" name="ainp_module_generate_category" value="1" <?php checked( ! empty( $this->plugin->options['module_generate_category'] ) ); ?>>
				<?php esc_html_e( 'Enable Category Assignment', 'ainp-ai-native-publisher' ); ?>
			</label>
		</div>
	</div>

	<div class="module-card">
		<div class="module-card-inner">
			<h3><?php esc_html_e( 'AI Tag Generation', 'ainp-ai-native-publisher' ); ?></h3>
			<p class="description"><?php esc_html_e( 'Uses the AI to generate relevant SEO tags for the post.', 'ainp-ai-native-publisher' ); ?></p>
			<label>
				<input type="checkbox" name="ainp_module_generate_tags" value="1" <?php checked( ! empty( $this->plugin->options['module_generate_tags'] ) ); ?>>
				<?php esc_html_e( 'Enable Tag Generation', 'ainp-ai-native-publisher' ); ?>
			</label>
		</div>
	</div>

	<div class="module-card">
		<div class="module-card-inner">
			<h3><?php esc_html_e( 'AI Image (Fallback)', 'ainp-ai-native-publisher' ); ?></h3>
			<p class="description"><?php esc_html_e( 'Generates a featured image using Google Imagen only if the source feed does NOT provide one.', 'ainp-ai-native-publisher' ); ?></p>
			<label>
				<input type="checkbox" name="ainp_module_generate_images" value="1" <?php checked( ! empty( $this->plugin->options['module_generate_images'] ) ); ?>>
				<?php esc_html_e( 'Enable Fallback Generation', 'ainp-ai-native-publisher' ); ?>
			</label>
		</div>
	</div>

	<div class="module-card ainp-pro-card">
		<div class="module-card-inner">
			<h3><?php esc_html_e( 'Force AI Image', 'ainp-ai-native-publisher' ); ?> <span class="dashicons dashicons-lock"></span></h3>
			<p class="description"><?php esc_html_e( 'Always generate a new image with AI, replacing any image found in the source feed.', 'ainp-ai-native-publisher' ); ?></p>
			<p>
				<a href="https://ainewspublisher.shop/" target="_blank" class="button button-secondary"><?php esc_html_e( 'Available in Pro', 'ainp-ai-native-publisher' ); ?></a>
			</p>
		</div>
	</div>

	<div class="module-card ainp-pro-card">
		<div class="module-card-inner">
			<h3><?php esc_html_e( 'Image Watermarking', 'ainp-ai-native-publisher' ); ?> <span class="dashicons dashicons-lock"></span></h3>
			<p class="description"><?php esc_html_e( 'Adds a predefined text watermark to images generated by the AI.', 'ainp-ai-native-publisher' ); ?></p>
			<p>
				<a href="https://ainewspublisher.shop/" target="_blank" class="button button-secondary"><?php esc_html_e( 'Available in Pro', 'ainp-ai-native-publisher' ); ?></a>
			</p>
		</div>
	</div>

	<div class="module-card">
		<div class="module-card-inner">
			<h3><?php esc_html_e( 'Source Credits', 'ainp-ai-native-publisher' ); ?></h3>
			<p class="description"><?php esc_html_e( 'Appends a credit line with a link to the original source article at the end of the post content.', 'ainp-ai-native-publisher' ); ?></p>
			<label>
				<input type="checkbox" name="ainp_module_source_credit" value="1" <?php checked( ! empty( $this->plugin->options['module_source_credit'] ) ); ?>>
				<?php esc_html_e( 'Enable Source Credits', 'ainp-ai-native-publisher' ); ?>
			</label>
		</div>
	</div>

	<div class="module-card ainp-pro-card">
		<div class="module-card-inner">
			<h3><?php esc_html_e( 'Keyword Filters', 'ainp-ai-native-publisher' ); ?> <span class="dashicons dashicons-lock"></span></h3>
			<p class="description"><?php esc_html_e( 'Skip processing articles based on inclusion or exclusion keywords found in the title or description.', 'ainp-ai-native-publisher' ); ?></p>
			<p>
				<a href="https://ainewspublisher.shop/" target="_blank" class="button button-secondary"><?php esc_html_e( 'Available in Pro', 'ainp-ai-native-publisher' ); ?></a>
			</p>
		</div>
	</div>

</div><hr>

<h3><?php esc_html_e( 'Module Settings', 'ainp-ai-native-publisher' ); ?></h3>

<table class="form-table">
	<tbody>
		<tr>
			<th scope="row">
				<label for="ainp_source_credit_format">
					<?php esc_html_e( 'Source Credit Line Format', 'ainp-ai-native-publisher' ); ?>
				</label>
			</th>
			<td>
				<input type="text" name="ainp_source_credit_format" id="ainp_source_credit_format" value="<?php echo esc_attr( $this->plugin->options['source_credit_format'] ?? '' ); ?>" class="large-text regular-text">
				<p class="description">
					<?php esc_html_e( 'Customize the HTML appended to the post content. Placeholders:', 'ainp-ai-native-publisher' ); ?>
					<code>{source_name}</code>, <code>{original_link}</code>.
				</p>
			</td>
		</tr>
	</tbody>
</table>

<h4><?php esc_html_e( 'Advanced Filtering', 'ainp-ai-native-publisher' ); ?></h4>
<div class="ainp-pro-wrapper">
	<div class="ainp-pro-content">
		<p class="description">
			<?php esc_html_e( 'Advanced Keyword Filtering allows you to specify exact words to Include (whitelist) or Exclude (blacklist) from processing. This helps maintain high content relevance automatically.', 'ainp-ai-native-publisher' ); ?>
		</p>
		<p>
			<a href="https://ainewspublisher.shop/" target="_blank" class="button button-primary"><?php esc_html_e( 'Upgrade to Pro to Unlock Filters', 'ainp-ai-native-publisher' ); ?></a>
		</p>
	</div>
</div>