<?php
/**
 * Diagnostics Tab View
 *
 * Renders the diagnostics page, displaying important server/WordPress environment
 * information and providing tools to test API connections and file system permissions.
 *
 * @package           AINP_AI_Native_Publisher
 * @author            AI News Publisher
 * @copyright         2025, AI News Publisher
 * @license           GPL-2.0+
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wp_version; // WordPress version global

// Get timestamp for next scheduled auto-fetch event
$ainp_next_scheduled_timestamp = wp_next_scheduled( AINP_AUTO_FETCH_CRON_HOOK );

// Timezone calculations for clarity
$ainp_server_time = gmdate( 'Y-m-d H:i:s' );
$ainp_wp_time     = wp_date( 'Y-m-d H:i:s' );
$ainp_timezone    = wp_timezone_string();
?>

<h3><?php esc_html_e( 'System Diagnostic Information', 'ainp-ai-native-publisher' ); ?></h3>
<p><?php esc_html_e( 'This information can be helpful for troubleshooting potential issues.', 'ainp-ai-native-publisher' ); ?></p>

<table class="wp-list-table widefat striped fixed ainp-diagnostics-table" style="max-width: 800px; margin-bottom: 30px;">
	<thead>
		<tr>
			<th scope="col" style="width: 35%; font-weight: 600;"><?php esc_html_e( 'Setting', 'ainp-ai-native-publisher' ); ?></th>
			<th scope="col" style="font-weight: 600;"><?php esc_html_e( 'Value', 'ainp-ai-native-publisher' ); ?></th>
		</tr>
	</thead>
	<tbody>
		<tr>
			<td><?php esc_html_e( 'WordPress Version', 'ainp-ai-native-publisher' ); ?></td>
			<td><?php echo esc_html( $wp_version ); ?></td>
		</tr>
		<tr>
			<td><?php esc_html_e( 'PHP Version', 'ainp-ai-native-publisher' ); ?></td>
			<td><?php echo esc_html( phpversion() ); ?></td>
		</tr>
		
		<tr>
			<td><?php esc_html_e( 'Site Timezone', 'ainp-ai-native-publisher' ); ?></td>
			<td><strong><?php echo esc_html( $ainp_timezone ); ?></strong></td>
		</tr>
		<tr>
			<td><?php esc_html_e( 'Current Server Time (UTC)', 'ainp-ai-native-publisher' ); ?></td>
			<td><code><?php echo esc_html( $ainp_server_time ); ?> UTC</code></td>
		</tr>
		<tr>
			<td><?php esc_html_e( 'Current WordPress Time', 'ainp-ai-native-publisher' ); ?></td>
			<td style="color: #0073aa; font-weight: bold;"><?php echo esc_html( $ainp_wp_time ); ?></td>
		</tr>
		<tr>
			<td><?php esc_html_e( 'Next Auto-Search Scheduled', 'ainp-ai-native-publisher' ); ?></td>
			<td>
				<?php
				if ( $ainp_next_scheduled_timestamp ) {
					// Show in WP Local Time
					echo '<strong>' . esc_html( wp_date( 'Y-m-d H:i:s', $ainp_next_scheduled_timestamp ) ) . '</strong>';
					
					// Calculate human readable diff
					$ainp_time_diff = human_time_diff( time(), $ainp_next_scheduled_timestamp );
					
					/* translators: %s: Time difference */
					echo ' <span class="description">(' . sprintf( esc_html__( 'in approx. %s', 'ainp-ai-native-publisher' ), esc_html( $ainp_time_diff ) ) . ')</span>';
				} else {
					echo '<span style="color: #787c82;">' . esc_html__( 'Not scheduled (Auto-search disabled or not configured)', 'ainp-ai-native-publisher' ) . '</span>';
				}
				?>
			</td>
		</tr>
		<tr>
			<td><?php esc_html_e( 'WP Cron Status', 'ainp-ai-native-publisher' ); ?></td>
			<td>
				<?php if ( defined( 'DISABLE_WP_CRON' ) && DISABLE_WP_CRON ) : ?>
					<span style="color: #dba617; font-weight: bold;"><?php esc_html_e( 'Disabled (External Cron Recommended)', 'ainp-ai-native-publisher' ); ?></span>
				<?php else : ?>
					<span style="color: #008a20; font-weight: bold;"><?php esc_html_e( 'Enabled (Standard)', 'ainp-ai-native-publisher' ); ?></span>
				<?php endif; ?>
			</td>
		</tr>
		<tr>
			<td><?php esc_html_e( 'PHP Max Execution Time', 'ainp-ai-native-publisher' ); ?></td>
			<td><?php echo esc_html( ini_get( 'max_execution_time' ) ); ?>s</td>
		</tr>
		<tr>
			<td><?php esc_html_e( 'PHP Memory Limit', 'ainp-ai-native-publisher' ); ?></td>
			<td><?php echo esc_html( ini_get( 'memory_limit' ) ); ?></td>
		</tr>
		<tr>
			<td><?php esc_html_e( 'cURL Enabled', 'ainp-ai-native-publisher' ); ?></td>
			<td>
				<?php if ( function_exists( 'curl_version' ) ) : ?>
					<span style="color: #008a20; font-weight: bold;"><?php esc_html_e( 'Yes', 'ainp-ai-native-publisher' ); ?></span>
				<?php else : ?>
					<span style="color: #d63638; font-weight: bold;"><?php esc_html_e( 'No (Required for API calls)', 'ainp-ai-native-publisher' ); ?></span>
				<?php endif; ?>
			</td>
		</tr>
		<tr>
			<td><?php esc_html_e( 'GD Library Enabled', 'ainp-ai-native-publisher' ); ?></td>
			<td>
				<?php if ( extension_loaded( 'gd' ) && function_exists( 'gd_info' ) ) : ?>
					<span style="color: #008a20; font-weight: bold;"><?php esc_html_e( 'Yes', 'ainp-ai-native-publisher' ); ?></span>
				<?php else : ?>
					<span style="color: #d63638; font-weight: bold;"><?php esc_html_e( 'No (Required for Watermarking)', 'ainp-ai-native-publisher' ); ?></span>
				<?php endif; ?>
			</td>
		</tr>
	</tbody>
</table>

<h3><?php esc_html_e( 'Connection & Permission Tests', 'ainp-ai-native-publisher' ); ?></h3>

<table class="form-table">
	<tbody>
		<tr>
			<th scope="row"><?php esc_html_e( 'Test API Connections', 'ainp-ai-native-publisher' ); ?></th>
			<td>
				<button type="button" id="ainp-test-api-button" class="button button-secondary ainp-action-button">
					<span class="button-text"><?php esc_html_e( 'Run API Tests', 'ainp-ai-native-publisher' ); ?></span>
					<span class="spinner"></span>
				</button>
				<p class="description"><?php esc_html_e( 'Verifies connectivity to configured AI services (Groq, Unsplash).', 'ainp-ai-native-publisher' ); ?></p>
				<div id="ainp-api-test-status" class="ainp-ajax-status" style="margin-top: 10px;"></div>
				
				<div class="ainp-pro-info-small" style="margin-top: 15px; font-size: 0.9em; color: #666; background: #f9f9f9; padding: 10px; border: 1px solid #e5e5e5; border-radius: 4px;">
					<strong><?php esc_html_e( 'Advanced Diagnostics (Pro):', 'ainp-ai-native-publisher' ); ?></strong>
					<ul style="margin: 5px 0 0 15px; list-style-type: none;">
						<li style="margin-bottom: 3px;"><span class="dashicons dashicons-lock" style="font-size: 14px; color: #888;"></span> <?php esc_html_e( 'Google Gemini Connection Test', 'ainp-ai-native-publisher' ); ?></li>
						<li><span class="dashicons dashicons-lock" style="font-size: 14px; color: #888;"></span> <?php esc_html_e( 'Google Imagen Connection Test', 'ainp-ai-native-publisher' ); ?></li>
					</ul>
				</div>
			</td>
		</tr>

		<tr>
			<th scope="row"><?php esc_html_e( 'Uploads Folder Write Permission', 'ainp-ai-native-publisher' ); ?></th>
			<td>
				<button type="button" id="ainp-test-write-permission-button" class="button button-secondary ainp-action-button">
					<span class="button-text"><?php esc_html_e( 'Test Write Permission', 'ainp-ai-native-publisher' ); ?></span>
					<span class="spinner"></span>
				</button>
				 <p class="description"><?php esc_html_e( 'Checks if the plugin can create and delete a temporary file in your WordPress uploads directory. Required for saving generated images.', 'ainp-ai-native-publisher' ); ?></p>
				 <div id="ainp-write-permission-test-status" class="ainp-ajax-status" style="margin-top: 10px;"></div>
			</td>
		</tr>
	</tbody>
</table>