<?php
/**
 * Dashboard Tab View
 *
 * Renders the main dashboard page for the plugin, displaying key statistics,
 * manual fetch controls, real-time status updates, and quick settings toggles.
 *
 * @package           AINP_AI_Native_Publisher
 * @author            AI News Publisher
 * @copyright         2025, AI News Publisher
 * @license           GPL-2.0+
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Check if the welcome panel has been dismissed by the current user.
$ainp_user_id = get_current_user_id();
$ainp_hide_welcome_panel = get_user_meta( $ainp_user_id, 'ainp_hide_welcome_panel', true );

// Fetch statistics for the dashboard cards.
$ainp_total_aggregated_posts = $this->plugin->get_total_plugin_posts_count();
$ainp_total_ai_images        = $this->plugin->get_total_ia_generated_images_count();
$ainp_active_sources_count   = $this->plugin->get_active_rss_feeds_count();

// Get the current state of quick setting toggles.
$ainp_enable_image_fallback  = ! empty( $this->plugin->options['module_generate_images'] ); // Fallback module
?>

<div class="ainp-dashboard">

	<?php if ( ! $ainp_hide_welcome_panel ) : ?>
	<div class="ainp-welcome-panel">
		<button type="button" id="ainp-dismiss-welcome-panel" class="notice-dismiss" title="<?php esc_attr_e( 'Dismiss this notice', 'ainp-ai-native-publisher' ); ?>">
			<span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice.', 'ainp-ai-native-publisher' ); ?></span>
		</button>
		<h2><?php esc_html_e( 'Welcome to AI Native Publisher!', 'ainp-ai-native-publisher' ); ?></h2>
		<p><?php esc_html_e( 'This plugin automates content aggregation and enrichment using AI. Here\'s what you can do in this version:', 'ainp-ai-native-publisher' ); ?></p>
		<ul>
			<li><?php esc_html_e( 'Aggregate content from RSS feeds.', 'ainp-ai-native-publisher' ); ?></li>
			<li><?php esc_html_e( 'Use AI (Groq/Gemini) to rewrite content, generate titles, categories, and tags.', 'ainp-ai-native-publisher' ); ?></li>
			<li><?php esc_html_e( 'Automatically generate featured images with Unsplash or Imagen.', 'ainp-ai-native-publisher' ); ?></li>
			<li><?php esc_html_e( 'Run manual fetches to keep your site updated.', 'ainp-ai-native-publisher' ); ?></li>
			<li><?php esc_html_e( 'Monitor progress and view detailed logs.', 'ainp-ai-native-publisher' ); ?></li>
		</ul>
		<p><?php esc_html_e( 'Use the controls below to start fetching content manually or manage quick settings.', 'ainp-ai-native-publisher' ); ?></p>
	</div>
	<?php endif; ?>

	<div class="ainp-dashboard-stat-cards-grid">
		<div class="ainp-stat-card">
			<div class="stat-icon"><span class="dashicons dashicons-admin-post"></span></div>
			<div class="stat-content">
				<div class="stat-value"><?php echo esc_html( number_format_i18n( $ainp_total_aggregated_posts ) ); ?></div>
				<div class="stat-label"><?php esc_html_e( 'Total Aggregated News', 'ainp-ai-native-publisher' ); ?></div>
			</div>
		</div>
		<div class="ainp-stat-card">
			<div class="stat-icon"><span class="dashicons dashicons-format-image"></span></div>
			 <div class="stat-content">
				<div class="stat-value"><?php echo esc_html( number_format_i18n( $ainp_total_ai_images ) ); ?></div>
				<div class="stat-label"><?php esc_html_e( 'AI Generated Images', 'ainp-ai-native-publisher' ); ?></div>
			</div>
		</div>
		<div class="ainp-stat-card">
			<div class="stat-icon"><span class="dashicons dashicons-rss"></span></div>
			<div class="stat-content">
				<div class="stat-value"><?php echo esc_html( number_format_i18n( $ainp_active_sources_count ) ); ?></div>
				<div class="stat-label"><?php esc_html_e( 'Active Content Sources', 'ainp-ai-native-publisher' ); ?></div>
			</div>
		</div>
	</div>

	<div class="ainp-dashboard-main-content">
		<div class="ainp-column-actions dashboard-column-actions">
			<h3><?php esc_html_e( 'Manual Fetch Actions', 'ainp-ai-native-publisher' ); ?></h3>

			<div class="action-item">
				<div class="action-label">
					<h4><?php esc_html_e( 'Fetch Next Single Item', 'ainp-ai-native-publisher' ); ?></h4>
					<p class="description"><?php esc_html_e( 'Processes only the latest item from the first source in your list. Good for quick testing.', 'ainp-ai-native-publisher' ); ?></p>
				</div>
				<div class="action-button-wrapper">
					<button type="button" id="ainp-dashboard-fetch-next" class="button ainp-action-button">
						<span class="button-text"><?php esc_html_e( 'Fetch Next', 'ainp-ai-native-publisher' ); ?></span>
						<span class="spinner"></span>
					</button>
				</div>
			</div>

			<div class="action-item">
				<div class="action-label">
					<h4><?php esc_html_e( 'Fetch All Sources Now', 'ainp-ai-native-publisher' ); ?></h4>
					<p class="description"><?php esc_html_e( 'Starts a background process to fetch items from all configured sources based on the depth selected below.', 'ainp-ai-native-publisher' ); ?></p>
					
					<div class="search-depth-options">
						<label style="display: block; margin-bottom: 5px; font-weight: 500;">
							<input type="radio" name="ainp_search_depth_choice" value="1" checked>
							<?php esc_html_e( 'Only the latest item per source', 'ainp-ai-native-publisher' ); ?>
						</label>
						
						<div class="ainp-pro-info-small" style="margin-top: 10px; font-size: 0.9em; color: #666; background: #f9f9f9; padding: 8px; border-radius: 4px;">
							<strong><?php esc_html_e( 'Available in Pro:', 'ainp-ai-native-publisher' ); ?></strong>
							<ul style="margin: 5px 0 0 15px; list-style-type: disc;">
								<li><?php esc_html_e( 'Fetch all new items', 'ainp-ai-native-publisher' ); ?></li>
								<li><?php esc_html_e( 'Custom depth (e.g., last 5 items)', 'ainp-ai-native-publisher' ); ?></li>
							</ul>
						</div>
					</div>
				</div>
				<div class="action-button-wrapper">
					<button type="button" id="ainp-dashboard-fetch-all" class="button button-primary ainp-action-button">
						<span class="button-text"><?php esc_html_e( 'Fetch All Now', 'ainp-ai-native-publisher' ); ?></span>
						<span class="spinner"></span>
					</button>
				</div>
			</div>

			<div class="status-area-container">
				 <div class="status-grid">
					<div class="status-item status-label"><?php esc_html_e( 'Current Status:', 'ainp-ai-native-publisher' ); ?></div>
					<div class="status-item status-value processing-status">--</div>
					<div class="status-item status-label"><?php esc_html_e( 'Progress:', 'ainp-ai-native-publisher' ); ?></div>
					<div class="status-item status-value processing-progress">--</div>
					<div class="status-item status-bar" aria-hidden="true">
						<div class="progress-bar-wrapper">
							<div class="progress-bar-inner processing-progress-bar" style="width: 0%;" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
						</div>
					</div>
					<div class="status-item status-cancel-button">
						 <button type="button" class="button button-secondary ainp-cancel-button" style="display:none;">
							<span class="button-text"><?php esc_html_e( 'Cancel Fetch', 'ainp-ai-native-publisher' ); ?></span>
							<span class="spinner"></span>
						</button>
					</div>
				</div>
				<div class="status-message-text processing-message">--</div>
				<div id="ainp-dashboard-fetch-status" class="ainp-ajax-status"></div> 
			</div>

		</div>
		
		<div class="ainp-column-settings dashboard-column-settings">
			<h3><?php esc_html_e( 'Quick Settings', 'ainp-ai-native-publisher' ); ?></h3>
			<div id="ainp-quick-settings-status" class="ainp-ajax-status"></div>
			
			<div class="control-item">
				<div class="control-label">
					<h4>
						<?php esc_html_e( 'Automatic Search', 'ainp-ai-native-publisher' ); ?>
						<span class="dashicons dashicons-lock" style="font-size: 16px; color: #888;" title="<?php esc_attr_e( 'Pro Feature', 'ainp-ai-native-publisher' ); ?>"></span>
					</h4>
					<p class="description">
						<?php esc_html_e( 'Enable/disable scheduled background fetching.', 'ainp-ai-native-publisher' ); ?>
					</p>
				</div>
				<div class="control-switch-placeholder">
					<a href="https://ainewspublisher.shop/" target="_blank" class="button button-small"><?php esc_html_e( 'Pro Feature', 'ainp-ai-native-publisher' ); ?></a>
				</div>
			</div>

			<div class="control-item">
				<div class="control-label">
					<h4><?php esc_html_e( 'AI Image Fallback', 'ainp-ai-native-publisher' ); ?></h4>
					<p class="description"><?php esc_html_e( 'Generate AI image if source has none.', 'ainp-ai-native-publisher' ); ?></p>
				</div>
				<div class="control-switch">
					<label class="switch" for="ainp-toggle-image-fallback">
						<input type="checkbox" id="ainp-toggle-image-fallback" <?php checked( $ainp_enable_image_fallback ); ?>>
						<span class="slider round"></span>
					</label>
				</div>
			</div>

			<div class="control-item">
				<div class="control-label">
					<h4>
						<?php esc_html_e( 'Force AI Image', 'ainp-ai-native-publisher' ); ?>
						<span class="dashicons dashicons-lock" style="font-size: 16px; color: #888;" title="<?php esc_attr_e( 'Pro Feature', 'ainp-ai-native-publisher' ); ?>"></span>
					</h4>
					<p class="description">
						<?php esc_html_e( 'Always generate AI image, ignore source image.', 'ainp-ai-native-publisher' ); ?>
					</p>
				</div>
				<div class="control-switch-placeholder">
					<a href="https://ainewspublisher.shop/" target="_blank" class="button button-small"><?php esc_html_e( 'Pro Feature', 'ainp-ai-native-publisher' ); ?></a>
				</div>
			</div>

			<div class="ainp-quick-links">
				<h3><?php esc_html_e( 'Configuration Links', 'ainp-ai-native-publisher' ); ?></h3>
				<p><a href="admin.php?page=ainp-sources" class="button button-secondary"><?php esc_html_e( 'Manage Sources & General Settings', 'ainp-ai-native-publisher' ); ?></a></p>
				<p><a href="admin.php?page=ainp-modules" class="button button-secondary"><?php esc_html_e( 'Configure Modules', 'ainp-ai-native-publisher' ); ?></a></p>
				<p><a href="admin.php?page=ainp-logs" class="button button-secondary"><?php esc_html_e( 'View Status & Detailed Logs', 'ainp-ai-native-publisher' ); ?></a></p>
			</div>
		</div>
	</div>
</div>