<?php
/**
 * Automatic Search Tab View
 *
 * Renders the settings page for configuring the automatic, cron-based
 * content fetching feature.
 *
 * @package           AINP_AI_Native_Publisher
 * @author            AI News Publisher
 * @copyright         2025, AI News Publisher
 * @license           GPL-2.0+
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Logic for calculating next run is unnecessary here as this feature is locked in Free version.
?>

<h3><?php esc_html_e( 'Automatic Search Settings', 'ainp-ai-native-publisher' ); ?></h3>
<p><?php esc_html_e( 'Configure the automatic content fetching engine. The Free version allows unlimited Manual Fetching.', 'ainp-ai-native-publisher' ); ?></p>

<div class="ainp-pro-wrapper">
	<div class="ainp-pro-content">
		<div class="ainp-feature-highlight">
			<h4><?php esc_html_e( 'Automate Your News Flow', 'ainp-ai-native-publisher' ); ?></h4>
			<p><?php esc_html_e( 'The Automatic Search engine runs in the background via WordPress Cron, keeping your site updated without manual intervention.', 'ainp-ai-native-publisher' ); ?></p>
			
			<table class="form-table" role="presentation">
				<tbody>
					<tr>
						<th scope="row"><span class="dashicons dashicons-update"></span> <?php esc_html_e( 'Background Processing', 'ainp-ai-native-publisher' ); ?></th>
						<td>
							<p><?php esc_html_e( 'Automatically fetches and processes news from your sources while you sleep.', 'ainp-ai-native-publisher' ); ?></p>
						</td>
					</tr>
					<tr>
						<th scope="row"><span class="dashicons dashicons-calendar-alt"></span> <?php esc_html_e( 'Flexible Intervals', 'ainp-ai-native-publisher' ); ?></th>
						<td>
							<p><?php esc_html_e( 'Choose from Hourly, Twice Daily, or Daily update schedules.', 'ainp-ai-native-publisher' ); ?></p>
						</td>
					</tr>
					<tr>
						<th scope="row"><span class="dashicons dashicons-filter"></span> <?php esc_html_e( 'Depth Control', 'ainp-ai-native-publisher' ); ?></th>
						<td>
							<p><?php esc_html_e( 'Define exactly how many items to fetch per source in each run to manage server load.', 'ainp-ai-native-publisher' ); ?></p>
						</td>
					</tr>
				</tbody>
			</table>

			<div class="ainp-cta-box" style="margin-top: 20px;">
				<a href="https://ainewspublisher.shop/" target="_blank" class="button button-primary hero"><?php esc_html_e( 'Upgrade to Pro to Enable Automation', 'ainp-ai-native-publisher' ); ?></a>
			</div>
		</div>
	</div>
</div>