<?php
/**
 * API Settings Tab View
 *
 * Renders the settings page for configuring API keys and model selections
 * for the AI services (Gemini, Groq, Imagen, Unsplash) used by the plugin.
 *
 * @package           AINP_AI_Native_Publisher
 * @author            AI News Publisher
 * @copyright         2025, AI News Publisher
 * @license           GPL-2.0+
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get current keys to pre-fill
$ainp_groq_key     = $this->plugin->options['groq_api_key'] ?? '';
$ainp_unsplash_key = $this->plugin->options['unsplash_access_key'] ?? '';
?>

<h3><?php esc_html_e( 'API Configuration', 'ainp-ai-native-publisher' ); ?></h3>
<p><?php esc_html_e( 'Configure the AI services used for content rewriting and image generation.', 'ainp-ai-native-publisher' ); ?></p>

<form method="post" action="">
	<?php wp_nonce_field( 'ainp_settings_nonce' ); ?>

	<div class="ainp-panel-section">
		<h4 style="margin-top: 0; border-bottom: 1px solid #eee; padding-bottom: 10px;"><?php esc_html_e( 'Text AI Provider', 'ainp-ai-native-publisher' ); ?></h4>
		
		<div class="ainp-status-row">
			<div class="ainp-status-item" style="margin-right: 20px;">
				<span class="dashicons dashicons-yes-alt" style="color: #46b450;"></span>
				<strong>Groq (Llama 3.1)</strong>
				<span class="description">- <?php esc_html_e( 'Active (Free)', 'ainp-ai-native-publisher' ); ?></span>
			</div>
			<div class="ainp-status-item" style="opacity: 0.7;">
				<span class="dashicons dashicons-lock" style="color: #888;"></span>
				<strong>Google Gemini</strong>
				<span class="description">- <?php esc_html_e( 'Available in Pro', 'ainp-ai-native-publisher' ); ?></span>
			</div>
		</div>

		<table class="form-table">
			<tbody>
				<tr>
					<th scope="row"><label for="ainp_groq_api_key"><?php esc_html_e( 'Groq API Key', 'ainp-ai-native-publisher' ); ?></label></th>
					<td>
						<input type="password" name="ainp_groq_api_key" id="ainp_groq_api_key" value="<?php echo esc_attr( $ainp_groq_key ); ?>" class="regular-text">
						<p class="description">
							<?php esc_html_e( 'Enter your Groq API Key.', 'ainp-ai-native-publisher' ); ?> 
							<a href="https://console.groq.com/keys" target="_blank"><?php esc_html_e( 'Get API Key', 'ainp-ai-native-publisher' ); ?></a>
						</p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'AI Model', 'ainp-ai-native-publisher' ); ?></th>
					<td>
						<p><strong>Llama 3.1 8b Instant</strong></p>
						<p class="description"><?php esc_html_e( 'Optimized for speed and efficiency in the Free version. Pro users can select Llama 3.1 70b or Mixtral 8x7b.', 'ainp-ai-native-publisher' ); ?></p>
					</td>
				</tr>
			</tbody>
		</table>
	</div>

	<div class="ainp-panel-section">
		<h4 style="margin-top: 0; border-bottom: 1px solid #eee; padding-bottom: 10px;"><?php esc_html_e( 'Image Generation Provider', 'ainp-ai-native-publisher' ); ?></h4>
		
		<div class="ainp-status-row">
			<div class="ainp-status-item" style="margin-right: 20px;">
				<span class="dashicons dashicons-yes-alt" style="color: #46b450;"></span>
				<strong>Unsplash (Stock Photos)</strong>
				<span class="description">- <?php esc_html_e( 'Active (Free)', 'ainp-ai-native-publisher' ); ?></span>
			</div>
			<div class="ainp-status-item" style="opacity: 0.7;">
				<span class="dashicons dashicons-lock" style="color: #888;"></span>
				<strong>Google Imagen (Vertex AI)</strong>
				<span class="description">- <?php esc_html_e( 'Available in Pro', 'ainp-ai-native-publisher' ); ?></span>
			</div>
		</div>

		<table class="form-table">
			<tbody>
				<tr>
					<th scope="row"><label for="ainp_unsplash_access_key"><?php esc_html_e( 'Unsplash Access Key', 'ainp-ai-native-publisher' ); ?></label></th>
					<td>
						<input type="password" name="ainp_unsplash_access_key" id="ainp_unsplash_access_key" value="<?php echo esc_attr( $ainp_unsplash_key ); ?>" class="regular-text">
						<p class="description">
							<?php esc_html_e( 'Enter your Unsplash Access Key.', 'ainp-ai-native-publisher' ); ?>
							<a href="https://unsplash.com/developers" target="_blank"><?php esc_html_e( 'Get API Key', 'ainp-ai-native-publisher' ); ?></a>
						</p>
						<p class="description" style="color: #666; margin-top: 8px; font-style: italic;">
							<?php esc_html_e( 'Note: If the key is left empty, the plugin will automatically use the original image from the RSS feed.', 'ainp-ai-native-publisher' ); ?>
						</p>
					</td>
				</tr>
			</tbody>
		</table>
	</div>

	<div class="ainp-pro-box">
		<h4><?php esc_html_e( 'Unlock Premium AI Integrations', 'ainp-ai-native-publisher' ); ?></h4>
		<p><?php esc_html_e( 'Upgrade to Pro to connect Google Gemini (Advanced Reasoning) and Google Imagen 3.0 (High-Fidelity Image Generation).', 'ainp-ai-native-publisher' ); ?></p>
		<p>
			<a href="https://ainewspublisher.shop/" target="_blank" class="button button-primary"><?php esc_html_e( 'View Pro Integrations', 'ainp-ai-native-publisher' ); ?></a>
		</p>
	</div>

	<p class="submit">
		<input type="submit" name="ainp_save_api_settings" class="button button-primary" value="<?php esc_attr_e( 'Save API Settings', 'ainp-ai-native-publisher' ); ?>">
	</p>
</form>