<?php
/**
 * AI Prompts Tab View
 *
 * Renders the settings page for visualizing the AI prompts used for
 * rewriting content, generating titles, categories, tags, and image descriptions.
 *
 * @package           AINP_AI_Native_Publisher
 * @author            AI News Publisher
 * @copyright         2025, AI News Publisher
 * @license           GPL-2.0+
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get current prompts (or defaults if not set)
$ainp_prompts = array(
	'prompt_rewrite'  => $this->plugin->options['prompt_rewrite'] ?? "Write a comprehensive news article based on the following content. \n\nGuidelines:\n- Maintain a professional and objective tone.\n- Use short paragraphs.\n- Include a catchy introduction.\n- Summarize key points.\n- Conclusion at the end.\n- Language: {target_language}",
	'prompt_title'    => $this->plugin->options['prompt_title'] ?? 'Generate a catchy, SEO-optimized title for this news article. Language: {target_language}. Return ONLY the title string.',
	'prompt_category' => $this->plugin->options['prompt_category'] ?? 'Suggest a single WordPress category for this news article. Return ONLY the category name. Language: {target_language}.',
	'prompt_tags'     => $this->plugin->options['prompt_tags'] ?? 'Generate 5 comma-separated tags for this news article. Language: {target_language}. Return ONLY the tags.',
	'prompt_imagen'   => $this->plugin->options['prompt_imagen'] ?? 'Create a prompt for an AI image generator to create a realistic featured image for this news article. Describe the scene vividly based on the title and summary.',
);
?>

<h3><?php esc_html_e( 'Active AI Prompts', 'ainp-ai-native-publisher' ); ?></h3>
<p><?php esc_html_e( 'These are the optimized system prompts currently powering your content engine. They ensure high-quality, neutral journalism automatically.', 'ainp-ai-native-publisher' ); ?></p>

<div class="ainp-prompts-preview">
	
	<table class="form-table" role="presentation">
		<tbody>
			<tr>
				<th scope="row"><?php esc_html_e( 'Content Rewrite', 'ainp-ai-native-publisher' ); ?></th>
				<td>
					<div class="ainp-code-preview">
						<code><?php echo nl2br( esc_html( $ainp_prompts['prompt_rewrite'] ) ); ?></code>
					</div>
					<p class="description"><?php esc_html_e( 'Main instruction used to rewrite and expand the news body.', 'ainp-ai-native-publisher' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Title Generation', 'ainp-ai-native-publisher' ); ?></th>
				<td>
					<div class="ainp-code-preview">
						<code><?php echo esc_html( $ainp_prompts['prompt_title'] ); ?></code>
					</div>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Category Assignment', 'ainp-ai-native-publisher' ); ?></th>
				<td>
					<div class="ainp-code-preview">
						<code><?php echo esc_html( $ainp_prompts['prompt_category'] ); ?></code>
					</div>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'SEO Tags', 'ainp-ai-native-publisher' ); ?></th>
				<td>
					<div class="ainp-code-preview">
						<code><?php echo esc_html( $ainp_prompts['prompt_tags'] ); ?></code>
					</div>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Image Prompt (GenAI)', 'ainp-ai-native-publisher' ); ?></th>
				<td>
					<div class="ainp-code-preview">
						<code><?php echo esc_html( $ainp_prompts['prompt_imagen'] ); ?></code>
					</div>
					<p class="description"><?php esc_html_e( 'Instruction used to generate the description that feeds the Image AI.', 'ainp-ai-native-publisher' ); ?></p>
				</td>
			</tr>
		</tbody>
	</table>

	<div class="ainp-pro-box" style="margin-top: 30px; padding: 20px; background: #f0f6fc; border: 1px solid #cce5ff; border-radius: 5px;">
		<h4><?php esc_html_e( 'Need Custom Prompts?', 'ainp-ai-native-publisher' ); ?></h4>
		<p><?php esc_html_e( 'Upgrade to Pro to fully customize these prompts. You can define specific tones (e.g., Sarcastic, Professional), force specific formats, or add custom SEO instructions.', 'ainp-ai-native-publisher' ); ?></p>
		<p>
			<a href="https://ainewspublisher.shop/" target="_blank" class="button button-primary"><?php esc_html_e( 'Unlock Custom Prompts', 'ainp-ai-native-publisher' ); ?></a>
		</p>
	</div>

</div>