<?php
/**
 * Advanced Settings Tab View
 *
 * Renders the advanced settings page, allowing users to view the technical
 * behaviors like execution timeout guards, automatic deletion policies,
 * and image processing modes.
 *
 * @package           AINP_AI_Native_Publisher
 * @author            AI News Publisher
 * @copyright         2025, AI News Publisher
 * @license           GPL-2.0+
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<h3><?php esc_html_e( 'Advanced Configuration', 'ainp-ai-native-publisher' ); ?></h3>
<p><?php esc_html_e( 'These low-level settings are optimized for stability and performance in the Free version.', 'ainp-ai-native-publisher' ); ?></p>

<form method="post" action="">
	<?php wp_nonce_field( 'ainp_settings_nonce' ); ?>
	
	<input type="hidden" name="ainp_enable_execution_timeout_guard" value="1">
	<input type="hidden" name="ainp_delete_awaiting_image_on_completion" value="1">
	<input type="hidden" name="ainp_image_processing_mode" value="async">

	<div class="ainp-status-panel">
		<table class="form-table" role="presentation">
			<tbody>
				<tr>
					<th scope="row"><?php esc_html_e( 'Execution Timeout Guard', 'ainp-ai-native-publisher' ); ?></th>
					<td>
						<p>
							<span class="dashicons dashicons-yes-alt" style="color: #46b450;"></span>
							<strong><?php esc_html_e( 'Active (Standard Protection)', 'ainp-ai-native-publisher' ); ?></strong>
						</p>
						<p class="description"><?php esc_html_e( 'Prevents the process from crashing by pausing before the server time limit is reached and rescheduling the rest.', 'ainp-ai-native-publisher' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Auto-Delete "Awaiting Image"', 'ainp-ai-native-publisher' ); ?></th>
					<td>
						<p>
							<span class="dashicons dashicons-yes-alt" style="color: #46b450;"></span>
							<strong><?php esc_html_e( 'Enabled', 'ainp-ai-native-publisher' ); ?></strong>
						</p>
						<p class="description"><?php esc_html_e( 'Keeps your site clean by automatically removing posts that failed to generate an image after the cycle ends.', 'ainp-ai-native-publisher' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Image Processing Mode', 'ainp-ai-native-publisher' ); ?></th>
					<td>
						<p>
							<span class="dashicons dashicons-update" style="color: #2271b1;"></span>
							<strong><?php esc_html_e( 'Asynchronous (Background)', 'ainp-ai-native-publisher' ); ?></strong>
						</p>
						<p class="description"><?php esc_html_e( 'Images are generated in background tasks to ensure faster page loads and prevent timeouts.', 'ainp-ai-native-publisher' ); ?></p>
					</td>
				</tr>
			</tbody>
		</table>
	</div>

	<div class="ainp-pro-box">
		<h4><?php esc_html_e( 'Need Manual Control?', 'ainp-ai-native-publisher' ); ?></h4>
		<p><?php esc_html_e( 'Advanced users can upgrade to Pro to disable safety guards, force Synchronous processing (immediate generation), or change deletion policies.', 'ainp-ai-native-publisher' ); ?></p>
		<p>
			<a href="https://ainewspublisher.shop/" target="_blank" class="button button-primary"><?php esc_html_e( 'Configure Advanced Settings', 'ainp-ai-native-publisher' ); ?></a>
		</p>
	</div>

	<div id="ainp-advanced-status" class="ainp-ajax-status"></div>

	<p class="submit">
		<input type="submit" name="ainp_save_advanced_settings" class="button button-secondary" value="<?php esc_attr_e( 'Refresh Configuration', 'ainp-ai-native-publisher' ); ?>">
	</p>
</form>