<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>
<div class="wrap">
    <h1><?php echo esc_html__('How to Get Your AiNisa Credentials', 'ainisa-chatbot'); ?></h1>

    <div class="card" style="max-width: 800px;">
        <h2><?php echo esc_html__('Getting Started with AiNisa Chatbot', 'ainisa-chatbot'); ?></h2>
        <p><?php echo esc_html__('Follow these steps to obtain your Integration UUID and API Key from AiNisa:', 'ainisa-chatbot'); ?></p>

        <hr>

        <h3><?php echo esc_html__('Step 1: Register an AiNisa Account', 'ainisa-chatbot'); ?></h3>
        <ol>
            <li><?php echo esc_html__('Visit', 'ainisa-chatbot'); ?> <a href="https://ainisa.com" target="_blank">https://ainisa.com</a></li>
            <li><?php echo esc_html__('Sign up for a new account', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('An API key will be automatically created for you upon registration', 'ainisa-chatbot'); ?></li>
        </ol>

        <h3><?php echo esc_html__('Step 2: Create an AI Assistant', 'ainisa-chatbot'); ?></h3>
        <ol>
            <li><?php echo esc_html__('Log in to your AiNisa dashboard', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('Create a new AI assistant if there is not any', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('Configure your assistant according to your business needs', 'ainisa-chatbot'); ?></li>
        </ol>

        <h3><?php echo esc_html__('Step 3: Create Website Integration', 'ainisa-chatbot'); ?></h3>
        <ol>
            <li><?php echo esc_html__('Go to', 'ainisa-chatbot'); ?> <a href="https://ainisa.com/business/integrations" target="_blank">https://ainisa.com/business/integrations</a></li>
            <li><?php echo esc_html__('Click "Create New Website Integration"', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('Select your AI assistant from the dropdown', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('Select your API key', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('Enter the domain(s) where the chat widget will work (e.g., yoursite.com)', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('Save the integration', 'ainisa-chatbot'); ?></li>
        </ol>

        <h3><?php echo esc_html__('Step 4: Get Your Integration Credentials', 'ainisa-chatbot'); ?></h3>
        <ol>
            <li><?php echo esc_html__('Click the', 'ainisa-chatbot'); ?> <strong>...</strong> <?php echo esc_html__('button on the right side of your integration', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('Click', 'ainisa-chatbot'); ?> <strong><?php echo esc_html__('Get Widget Code', 'ainisa-chatbot'); ?></strong></li>
            <li><?php echo esc_html__('Find the', 'ainisa-chatbot'); ?> <strong><?php echo esc_html__('WordPress', 'ainisa-chatbot'); ?></strong> <?php echo esc_html__('section in the opened page', 'ainisa-chatbot'); ?></li>
            <li><strong><?php echo esc_html__('Copy the Integration UUID and API Key displayed there', 'ainisa-chatbot'); ?></strong></li>
            <li><?php echo esc_html__('You can copy your Secret Key on that page if you want to enable user data collection', 'ainisa-chatbot'); ?></li>
        </ol>

        <h3><?php echo esc_html__('Step 5: Configure WordPress Plugin', 'ainisa-chatbot'); ?></h3>
        <ol>
            <li><?php echo esc_html__('Go to', 'ainisa-chatbot'); ?> <a href="<?php echo esc_url(admin_url('admin.php?page=ainisa-chatbot-admin')); ?>"><?php echo esc_html__('AiNisa Chatbot Settings', 'ainisa-chatbot'); ?></a></li>
            <li><?php echo esc_html__('Paste your Integration UUID from Step 4', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('Paste your API Key from Step 4', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('(Optional) Paste your Secret Key if you want to collect logged-in user data', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('Click "Save Settings"', 'ainisa-chatbot'); ?></li>
        </ol>

        <hr>

        <h3><?php echo esc_html__('Optional: Enable User Data Collection', 'ainisa-chatbot'); ?></h3>
        <p><?php echo esc_html__('If you want to provide a personalized chat experience for logged-in users:', 'ainisa-chatbot'); ?></p>
        <ul>
            <li><?php echo esc_html__('Add your Secret Key in the plugin settings', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('The plugin will automatically collect user information (ID, name, email) for logged-in WordPress users', 'ainisa-chatbot'); ?></li>
            <li><?php echo esc_html__('This data is securely transmitted to AiNisa for personalized responses', 'ainisa-chatbot'); ?></li>
        </ul>

        <hr>

        <h3><?php echo esc_html__('Additional Resources', 'ainisa-chatbot'); ?></h3>
        <ul>
            <li><strong><?php echo esc_html__('Documentation:', 'ainisa-chatbot'); ?></strong> <a href="https://docs.ainisa.com/integrations/web.html" target="_blank">https://docs.ainisa.com/integrations/web.html</a></li>
            <li><strong><?php echo esc_html__('API Keys:', 'ainisa-chatbot'); ?></strong> <a href="https://ainisa.com/business/api-keys" target="_blank">https://ainisa.com/business/api-keys</a></li>
            <li><strong><?php echo esc_html__('Integrations:', 'ainisa-chatbot'); ?></strong> <a href="https://ainisa.com/business/integrations" target="_blank">https://ainisa.com/business/integrations</a></li>
        </ul>

        <div class="notice notice-info inline" style="margin-top: 20px;">
            <p>
                <strong><?php echo esc_html__('Important:', 'ainisa-chatbot'); ?></strong>
                <?php echo esc_html__('Make sure the domain(s) you enter in the AiNisa integration settings match your WordPress site domain. The chatbot widget will only work on authorized domains.', 'ainisa-chatbot'); ?>
            </p>
        </div>

        <div class="notice notice-warning inline" style="margin-top: 10px;">
            <p>
                <strong><?php echo esc_html__('Security Note:', 'ainisa-chatbot'); ?></strong>
                <?php echo esc_html__('Keep your API Key and Secret Key secure. Never share these credentials publicly or commit them to public repositories.', 'ainisa-chatbot'); ?>
            </p>
        </div>
    </div>

    <p style="margin-top: 20px;">
        <a href="<?php echo esc_url(admin_url('admin.php?page=ainisa-chatbot-admin')); ?>" class="button button-primary">
            <?php echo esc_html__('Go to Settings', 'ainisa-chatbot'); ?>
        </a>
        <a href="https://docs.ainisa.com/integrations/web.html" target="_blank" class="button">
            <?php echo esc_html__('Read Full Documentation', 'ainisa-chatbot'); ?>
        </a>
    </p>
</div>