<?php
// Uninstall cleanup for AiGude Tools
// This file is executed when the plugin is uninstalled from WordPress.

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

/**
 * Clean up plugin options and generated attachment meta.
 * - Options: 'aigude_alt_servers', 'aigude_target_language'
 * - Attachment meta: any meta_key starting with '_aigude_alt_'
 */

$delete_for_site = static function () {
    // Plugin options
    delete_option( 'aigude_alt_servers' );
    delete_option( 'aigude_target_language' );

    // Known meta keys created by this plugin (v2: no per-language translation metas)
    $meta_keys = array( '_aigude_alt_suggestion' );

    foreach ( $meta_keys as $mk ) {
        // Delete all occurrences across all posts
        delete_post_meta_by_key( $mk );
    }

    // User meta: recent language selections
    foreach ( [ 'ai_recent_langs_target', 'ai_recent_langs_prompt', 'ai_recent_langs_placeholder' ] as $umk ) {
        delete_metadata( 'user', 0, $umk, '', true );
    }
};

if ( is_multisite() ) {
    $site_ids = get_sites( array( 'fields' => 'ids' ) );
    foreach ( $site_ids as $site_id ) {
        switch_to_blog( (int) $site_id );
        $delete_for_site();
        restore_current_blog();
    }
} else {
    $delete_for_site();
}
