<?php
/**
 * Admin menus and assets for AiGude Tools.
 */

if (!defined('ABSPATH')) {
    exit;
}

class AIGUDE_Admin_UI {
    /**
     * Attach all admin-facing actions (menus, scripts, labels).
     */
    public function register(): void {
        add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_assets']);
        add_action('admin_menu', [$this, 'register_admin_menus']);
        add_action('admin_head', [$this, 'rename_first_submenu_to_list']);
    }

    /**
     * Load CSS/JS for the current admin screen, including localized data for JS apps.
     */
    public function enqueue_admin_assets(string $hook): void {
        wp_enqueue_style('dashicons');
        wp_enqueue_script('jquery');

        $base_css_path = AIGUDE_Tools_Plugin::plugin_path('assets/css/base.css');
        wp_enqueue_style(
            'ai-admin-style',
            AIGUDE_Tools_Plugin::plugin_url('assets/css/base.css'),
            [],
            file_exists($base_css_path) ? filemtime($base_css_path) : null
        );

        $menu_slug = AIGUDE_Tools_Plugin::MENU_SLUG;

        if ($hook === 'toplevel_page_' . $menu_slug || $hook === $menu_slug . '_page_alttext-list') {
            $list_js_path = AIGUDE_Tools_Plugin::plugin_path('assets/js/list-actions.js');
            wp_enqueue_script(
                'ai-list-actions',
                AIGUDE_Tools_Plugin::plugin_url('assets/js/list-actions.js'),
                ['jquery', 'wp-i18n'],
                file_exists($list_js_path) ? filemtime($list_js_path) : null,
                true
            );
            wp_localize_script('ai-list-actions', 'aigudeToolsListData', [
                'perImageCredits' => AIGUDE_Tools_Plugin::PER_IMAGE_CREDITS,
                'nonce'           => wp_create_nonce(AIGUDE_Tools_Plugin::NONCE_ACTION),
                'ajaxUrl'         => admin_url('admin-ajax.php'),
            ]);
            wp_set_script_translations(
                'ai-list-actions',
                'aigude-tools',
                AIGUDE_Tools_Plugin::plugin_path('languages')
            );
            return;
        }

        if ($hook === $menu_slug . '_page_aigude-tools-grid') {
            wp_enqueue_media();
            $grid_js_path = AIGUDE_Tools_Plugin::plugin_path('assets/js/grid-actions.js');
            wp_enqueue_script(
                'ai-grid-actions',
                AIGUDE_Tools_Plugin::plugin_url('assets/js/grid-actions.js'),
                ['jquery', 'media-editor', 'media-views', 'wp-util', 'wp-i18n'],
                file_exists($grid_js_path) ? filemtime($grid_js_path) : null,
                true
            );
            wp_localize_script('ai-grid-actions', 'aigudeToolsGridData', [
                'ajaxUrl'          => admin_url('admin-ajax.php'),
                'nonce'            => wp_create_nonce(AIGUDE_Tools_Plugin::NONCE_ACTION),
                'defaultSkip'      => true,
                'selectors'        => [
                    'prompt'       => '#global-prompt',
                    'language'     => '#ai_target_language',
                    'miniGrid'     => '#media-selected-grid',
                    'generateBtn'  => '#media-generate',
                    'selectBtn'    => '#media-select',
                    'progressBar'  => '#bulk-progress-bar',
                    'progressWrap' => '#bulk-progress',
                    'skipExisting' => '#skip-existing',
                ],
                'perImageCredits'  => AIGUDE_Tools_Plugin::PER_IMAGE_CREDITS,
                'batchSize'        => 1,
                'selectAllMax'     => 2000,
                'urls'             => [
                    'library' => admin_url('upload.php'),
                    'edit'    => admin_url('post.php'),
                ],
                'openTarget'       => 'library',
            ]);
            wp_set_script_translations(
                'ai-grid-actions',
                'aigude-tools',
                AIGUDE_Tools_Plugin::plugin_path('languages')
            );
            return;
        }

        if ($hook === $menu_slug . '_page_aigude-tools-settings') {
            $server_js_path = AIGUDE_Tools_Plugin::plugin_path('assets/js/server-actions.js');
            wp_enqueue_script(
                'ai-server-actions',
                AIGUDE_Tools_Plugin::plugin_url('assets/js/server-actions.js'),
                ['jquery', 'wp-i18n'],
                file_exists($server_js_path) ? filemtime($server_js_path) : null,
                true
            );
            wp_localize_script('ai-server-actions', 'aigudeServerData', [
                'ajaxUrl' => admin_url('admin-ajax.php'),
                'nonce'   => wp_create_nonce(AIGUDE_Tools_Plugin::NONCE_ACTION),
            ]);
            wp_set_script_translations(
                'ai-server-actions',
                'aigude-tools',
                AIGUDE_Tools_Plugin::plugin_path('languages')
            );
        }
    }

    /**
     * Register the AiGude top-level menu and supporting submenu pages.
     */
    public function register_admin_menus(): void {
        add_menu_page(
            esc_html__('AiGude Tools', 'aigude-tools'),
            esc_html__('AiGude Tools', 'aigude-tools'),
            'manage_options',
            AIGUDE_Tools_Plugin::MENU_SLUG,
            'aigude_tools_render_list_page',
            'dashicons-format-image',
            99
        );

        add_submenu_page(
            AIGUDE_Tools_Plugin::MENU_SLUG,
            esc_html__('Grid view (Media Modal)', 'aigude-tools'),
            esc_html__('Grid view', 'aigude-tools'),
            'manage_options',
            'aigude-tools-grid',
            'aigude_tools_render_grid_page'
        );

        add_submenu_page(
            AIGUDE_Tools_Plugin::MENU_SLUG,
            esc_html__('Settings', 'aigude-tools'),
            esc_html__('Settings', 'aigude-tools'),
            'manage_options',
            'aigude-tools-settings',
            'aigude_server_settings_page'
        );

        add_submenu_page(
            AIGUDE_Tools_Plugin::MENU_SLUG,
            esc_html__('Prompts', 'aigude-tools'),
            esc_html__('Prompts', 'aigude-tools'),
            'manage_options',
            'aigude-tools-prompts',
            'aigude_prompt_templates_page'
        );
    }

    /**
     * Rename the generated first submenu item to “List view” for clarity.
     */
    public function rename_first_submenu_to_list(): void {
        global $submenu;
        if (isset($submenu[AIGUDE_Tools_Plugin::MENU_SLUG][0])) {
            $submenu[AIGUDE_Tools_Plugin::MENU_SLUG][0][0] = esc_html__('List view', 'aigude-tools');
        }
    }
}
