// assets/js/server-actions.js
(function ($) {
    'use strict';
    const { __ } = wp.i18n;

    // Translatable strings
    const STR = {
        show:           __('Show', 'aigude-tools'),
        hide:           __('Hide', 'aigude-tools'),
        errorFetching:  __('Error during retrieval', 'aigude-tools'),
        copyFailed:     __('Copy failed', 'aigude-tools'),
    };

    $(function () {
        $.post((window.ajaxurl || (window.aigudeServerData && aigudeServerData.ajaxUrl) || ''), {
            action: 'aigude_get_all_credits',
            _ajax_nonce: (window.aigudeServerData && aigudeServerData.nonce) || ''
        })
            .done(function (res) {
                if (res && res.success && res.data) {
                    $('.ai-server-credits').each(function () {
                        const idx = $(this).data('index');
                        const val = typeof res.data[idx] !== 'undefined' ? res.data[idx] : STR.errorFetching;
                        $(this).text(val);
                    });
                } else {
                    $('.ai-server-credits').text(STR.errorFetching);
                }
            })
            .fail(function () {
                $('.ai-server-credits').text(STR.errorFetching);
            });
    });

    // Remember masked value
    $(function () {
        $('.api-key-mask').each(function () {
            const $span = $(this);
            if (!$span.data('masked')) {
                $span.data('masked', $span.text());
            }
        });
    });

    // Toggle show/hide (list view)
    $(document).on('click', '.toggle-api-key', function (e) {
        e.preventDefault();
        const $link = $(this);
        const $span = $link.siblings('.api-key-mask');

        if ($span.hasClass('revealed')) {
            // Hide again
            let masked = $span.data('masked');
            if (!masked) {
                const fullForLen = $span.data('full') || '';
                masked = '*'.repeat(Math.max(4, fullForLen.length));
            }
            $span.text(masked).removeClass('revealed');
            $link.text(STR.show);
        } else {
            // Show
            const full = $span.data('full') || '';
            $span.text(full).addClass('revealed');
            $link.text(STR.hide);
        }
    });

    // Toggle visibility on edit/add forms
    $(document).on('click', '.api-key-visibility', function (e) {
        e.preventDefault();
        const $btn   = $(this);
        const $input = $($btn.data('target'));
        const isPass = $input.attr('type') === 'password';

        $input.attr('type', isPass ? 'text' : 'password');
        $btn.attr('aria-pressed', isPass ? 'true' : 'false');
        $btn.text(isPass ? STR.hide : STR.show);
    });

    // Copy API key to clipboard
    $(document).on('click', '.api-key-copy', async function (e) {
        e.preventDefault();
        const $input = $($(this).data('target'));
        try {
            await navigator.clipboard.writeText($input.val() || '');
        } catch (err) {
            alert(STR.copyFailed);
        }
    });
})(jQuery);
