<?php
/*
Plugin Name: Aigrow Chatbot Integration
Description: Integrates Aigrow chatbot with WordPress and manages the token
Text Domain: aigrow-chatbot-integration
Plugin URI: https://wordpress.org/plugins/aigrow-chatbot-integration
Version: 1.0.6 
Author: Your Name
Contributors: gayoacehcoffee
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

// Prevent direct file access
if (!defined('ABSPATH')) {
    exit;
}

// Add menu item to WordPress admin
function aigrow_chatbot_menu() {
    add_menu_page(
        'Aigrow Chatbot Settings',
        'Aigrow Chatbot',
        'manage_options',
        'aigrow-chatbot-settings',
        'aigrow_chatbot_settings_page',
        'dashicons-format-chat'
    );
}
add_action('admin_menu', 'aigrow_chatbot_menu');

// Create the settings page
function aigrow_chatbot_settings_page() {
    // Save settings if form is submitted
    if (isset($_POST['aigrow_token']) && check_admin_referer('aigrow_chatbot_settings')) {
        update_option('aigrow_chatbot_token', sanitize_text_field(wp_unslash($_POST['aigrow_token'])));
        if (isset($_POST['aigrow_title'])) {
            update_option('aigrow_chatbot_title', sanitize_text_field(wp_unslash($_POST['aigrow_title'])));
        }
        if (isset($_POST['aigrow_ws_url'])) {
            update_option('aigrow_chatbot_ws_url', sanitize_text_field(wp_unslash($_POST['aigrow_ws_url'])));
        }
        echo '<div class="notice notice-success"><p>Settings saved successfully!</p></div>';
    }

    // Get current values
    $token = get_option('aigrow_chatbot_token', '');
    $title = get_option('aigrow_chatbot_title', 'Research Paper Drafter');
    $ws_url = get_option('aigrow_chatbot_ws_url', 'wss://gayoacehcoffee.my.id');
    ?>
    <div class="wrap">
        <div style="display: flex; align-items: center; margin-bottom: 20px;">
            <img src="<?php echo plugins_url('assets/img/logo.png', __FILE__); ?>" alt="Aigrow Logo" style="height: 60px; margin-right: 15px;">
            <h1>Aigrow Chatbot Settings</h1>
        </div>
        
        <div style="margin-bottom: 30px; max-width: 1200px;">
            <img src="<?php echo plugins_url('assets/img/banner.jpeg', __FILE__); ?>" alt="Aigrow Banner" style="max-width: 100%; height: auto; border-radius: 5px; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
        </div>
        
        <div style="max-width: 800px;">
            <form method="post" action="">
                <?php wp_nonce_field('aigrow_chatbot_settings'); ?>
                <table class="form-table">
                    <tr>
                        <th scope="row">Chatbot Token</th>
                        <td>
                            <input type="text" name="aigrow_token" value="<?php echo esc_attr($token); ?>" class="regular-text">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Chatbot Title</th>
                        <td>
                            <input type="text" name="aigrow_title" value="<?php echo esc_attr($title); ?>" class="regular-text">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">WebSocket URL</th>
                        <td>
                            <input type="text" name="aigrow_ws_url" value="<?php echo esc_attr($ws_url); ?>" class="regular-text">
                        </td>
                    </tr>
                </table>
                <?php submit_button(); ?>
            </form>
        </div>
    </div>
    <?php
}

// Enqueue chatbot script
function aigrow_enqueue_chatbot_script() {
    $token = get_option('aigrow_chatbot_token', '');
    $title = get_option('aigrow_chatbot_title', 'Research Paper Drafter');
    $ws_url = get_option('aigrow_chatbot_ws_url', 'wss://gayoacehcoffee.my.id');
    $logo_url = plugins_url('assets/img/logo.png', __FILE__);

    if (!empty($token)) {
        // Register and enqueue the widget script
        if (file_exists(plugin_dir_path(__FILE__) . 'assets/js/widget.js')) {
            wp_register_script('aigrow-chatbot-widget', plugins_url('assets/js/widget.js', __FILE__), array(), '1.0.6', true);
            wp_enqueue_script('aigrow-chatbot-widget');
        }
        
        // Localize script with settings
        wp_add_inline_script('aigrow-chatbot-widget', 
            "const chatWidget = new ChatWidget('" . esc_js($token) . "', '" . esc_js($title) . "', '" . esc_js($ws_url) . "', '" . esc_js($logo_url) . "');"
        );
    }
}
add_action('wp_enqueue_scripts', 'aigrow_enqueue_chatbot_script');

// Add Tailwind CSS
function aigrow_add_tailwind() {
    wp_enqueue_style(
        'aigrow-tailwind',
        plugins_url('assets/css/tailwind.min.css', __FILE__),
        array(),
        '3.4.1'
    );
}
add_action('wp_enqueue_scripts', 'aigrow_add_tailwind');

// Activation hook
function aigrow_chatbot_activate() {
    // Initialize default options if they don't exist
    add_option('aigrow_chatbot_token', '');
    add_option('aigrow_chatbot_title', 'Research Paper Drafter');
    add_option('aigrow_chatbot_ws_url', 'wss://gayoacehcoffee.my.id');
}
register_activation_hook(__FILE__, 'aigrow_chatbot_activate');

// Deactivation hook
function aigrow_chatbot_deactivate() {
    // Clean up if needed
}
register_deactivation_hook(__FILE__, 'aigrow_chatbot_deactivate');

// Uninstall hook
function aigrow_chatbot_uninstall() {
    delete_option('aigrow_chatbot_token');
    delete_option('aigrow_chatbot_title');
    delete_option('aigrow_chatbot_ws_url');
}
register_uninstall_hook(__FILE__, 'aigrow_chatbot_uninstall');
