<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    aicoso_pickup_delivery
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Only remove options if the user has specified to do so.
if ( get_option( 'aicoso_pickup_delivery_delete_data_on_uninstall' ) === 'yes' ) {
	// Remove all plugin options.
	delete_option( 'aicoso_pickup_delivery_settings' );
	delete_option( 'aicoso_pickup_delivery_delivery_time_slots' );
	delete_option( 'aicoso_pickup_delivery_pickup_time_slots' );
	delete_option( 'aicoso_pickup_delivery_pickup_locations' );
	delete_option( 'aicoso_pickup_delivery_blackout_dates' );
	delete_option( 'aicoso_pickup_delivery_delete_data_on_uninstall' );

	// Remove capabilities from roles.
	$admin_role = get_role( 'administrator' );
	if ( $admin_role ) {
		$admin_role->remove_cap( 'manage_aicoso_pickup_delivery' );
	}

	// Remove order meta data.
	global $wpdb;

	/**
	 * Delete all pickup/delivery postmeta.
	 *
	 * Note: Direct database query is necessary here for bulk deletion during uninstall.
	 * Caching is not relevant as this is a one-time cleanup operation.
	 * Using delete_post_meta() in a loop would be inefficient for large datasets.
	 */
	// phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
	$wpdb->query(
		$wpdb->prepare(
			"DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE %s",
			'_aicoso_pickup_delivery_%'
		)
	);
	// phpcs:enable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching

	// Clear any cached data that might be lingering.
	wp_cache_flush();
}
