<?php
/**
 * Pickup details template for My Account.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/pickup-details.php
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get pickup details.
$pickup_date     = $order->get_meta( '_aicoso_pickup_delivery_pickup_date', true );
$pickup_time     = $order->get_meta( '_aicoso_pickup_delivery_pickup_time_slot', true );
$pickup_location = $order->get_meta( '_aicoso_pickup_delivery_pickup_location', true );

// Get location details if available.
$location_data = array();
if ( $pickup_location ) {
	$location_data = AICOSO_Pickup_Delivery_Location_Manager::get_location_by_name( $pickup_location );
}

// Only display if we have pickup details.
if ( ! $pickup_date && ! $pickup_time && ! $pickup_location ) {
	return;
}
?>

<h2><?php esc_html_e( 'Pickup Information', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h2>

<table class="woocommerce-table woocommerce-table--pickup-details shop_table pickup_details">
	<tbody>
		<?php if ( $pickup_date ) : ?>
			<tr>
				<th><?php esc_html_e( 'Pickup Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				<td><?php echo esc_html( AICOSO_Pickup_Delivery_Data::format_date( $pickup_date ) ); ?></td>
			</tr>
		<?php endif; ?>
		
		<?php if ( $pickup_time ) : ?>
			<tr>
				<th><?php esc_html_e( 'Pickup Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				<td><?php echo esc_html( $pickup_time ); ?></td>
			</tr>
		<?php endif; ?>
		
		<?php if ( $pickup_location ) : ?>
			<tr>
				<th><?php esc_html_e( 'Pickup Location:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				<td><?php echo esc_html( $pickup_location ); ?></td>
			</tr>
			
			<?php if ( ! empty( $location_data ) && isset( $location_data['location_address'] ) && ! empty( $location_data['location_address'] ) ) : ?>
				<tr>
					<th><?php esc_html_e( 'Address:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<td><?php echo esc_html( $location_data['location_address'] ); ?></td>
				</tr>
			<?php endif; ?>
			
			<?php if ( ! empty( $location_data ) && isset( $location_data['location_map_url'] ) && ! empty( $location_data['location_map_url'] ) ) : ?>
				<tr>
					<th><?php esc_html_e( 'Map:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<td>
						<a href="<?php echo esc_url( $location_data['location_map_url'] ); ?>" target="_blank">
							<?php esc_html_e( 'View on Google Maps', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
						</a>
					</td>
				</tr>
			<?php endif; ?>
		<?php endif; ?>
	</tbody>
</table>