<?php
/**
 * Delivery details template for My Account.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/delivery-details.php
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get delivery details.
$delivery_date = $order->get_meta( '_aicoso_pickup_delivery_delivery_date', true );
$delivery_time = $order->get_meta( '_aicoso_pickup_delivery_delivery_time_slot', true );

// Only display if we have delivery details.
if ( ! $delivery_date && ! $delivery_time ) {
	return;
}
?>

<h2><?php esc_html_e( 'Delivery Information', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h2>

<table class="woocommerce-table woocommerce-table--delivery-details shop_table delivery_details">
	<tbody>
		<?php if ( $delivery_date ) : ?>
			<tr>
				<th><?php esc_html_e( 'Delivery Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				<td><?php echo esc_html( AICOSO_Pickup_Delivery_Data::format_date( $delivery_date ) ); ?></td>
			</tr>
		<?php endif; ?>
		
		<?php if ( $delivery_time ) : ?>
			<tr>
				<th><?php esc_html_e( 'Delivery Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				<td><?php echo esc_html( $delivery_time ); ?></td>
			</tr>
		<?php endif; ?>
	</tbody>
</table>