<?php
/**
 * Pickup confirmation email (plain text).
 *
 * This template can be overridden by copying it to yourtheme/aicoso-pickup-and-delivery-for-woocommerce/emails/plain/pickup-confirmation.php.
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

echo "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n";
echo esc_html( wp_strip_all_tags( $email_heading ) );
echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

// translators: %s: Customer first name.
echo sprintf( esc_html__( 'Hi %s,', 'aicoso-pickup-and-delivery-for-woocommerce' ), esc_html( $order->get_billing_first_name() ) ) . "\n\n";
echo esc_html__( 'Your order is confirmed for pickup. Below are the details:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . "\n\n";

// Get pickup details.
$pickup_date     = $order->get_meta( '_aicoso_pickup_delivery_pickup_date', true );
$pickup_time     = $order->get_meta( '_aicoso_pickup_delivery_pickup_time_slot', true );
$pickup_location = $order->get_meta( '_aicoso_pickup_delivery_pickup_location', true );

echo "\n----------------------------------------\n";
echo esc_html__( 'Pickup Information', 'aicoso-pickup-and-delivery-for-woocommerce' ) . "\n";
echo "----------------------------------------\n";

if ( $pickup_date ) {
	echo esc_html__( 'Pickup Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( $pickup_date ) . "\n";
}

if ( $pickup_time ) {
	echo esc_html__( 'Pickup Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( $pickup_time ) . "\n";
}

if ( $pickup_location ) {
	echo esc_html__( 'Pickup Location:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( $pickup_location ) . "\n";
}

echo "\n";

/**
 * Show order details
 */
do_action( 'woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email );

echo "\n----------------------------------------\n\n";

/**
 * Show customer details
 */
do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

echo "\n----------------------------------------\n\n";

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ( $additional_content ) {
	echo esc_html( wp_strip_all_tags( wptexturize( $additional_content ) ) );
	echo "\n\n----------------------------------------\n\n";
}

echo wp_kses_post( apply_filters( 'woocommerce_email_footer_text', get_option( 'woocommerce_email_footer_text' ) ) );
