<?php
/**
 * Delivery confirmation email (plain text).
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/plain/delivery-confirmation.php.
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

echo "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n";
echo esc_html( wp_strip_all_tags( $email_heading ) );
echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

// translators: %s: Customer first name.
echo sprintf( esc_html__( 'Hi %s,', 'aicoso-pickup-and-delivery-for-woocommerce' ), esc_html( $order->get_billing_first_name() ) ) . "\n\n";

echo esc_html__( 'Your order has been confirmed for delivery. Here are the details:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . "\n\n";

echo "----------------------------------------\n";
echo esc_html__( 'DELIVERY INFORMATION', 'aicoso-pickup-and-delivery-for-woocommerce' ) . "\n";
echo "----------------------------------------\n\n";

$delivery_date = $order->get_meta( '_aicoso_pickup_delivery_delivery_date', true );
$delivery_time = $order->get_meta( '_aicoso_pickup_delivery_delivery_time_slot', true );

if ( $delivery_date ) {
	echo esc_html__( 'Delivery Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( date_i18n( get_option( 'date_format' ), strtotime( $delivery_date ) ) ) . "\n";
}

if ( $delivery_time ) {
	echo esc_html__( 'Delivery Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( ucfirst( str_replace( '_', ' ', $delivery_time ) ) ) . "\n";
}

echo esc_html__( 'Delivery Address:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . "\n";
echo esc_html( wp_strip_all_tags( $order->get_formatted_shipping_address() ) ) . "\n";

if ( $order->get_shipping_phone() ) {
	echo esc_html( $order->get_shipping_phone() ) . "\n";
}

echo "\n----------------------------------------\n\n";

/*
 * @hooked WC_Emails::order_details() Shows the order details table.
 * @hooked WC_Structured_Data::generate_order_data() Generates structured data.
 * @hooked WC_Structured_Data::output_structured_data() Outputs structured data.
 * @since 2.5.0
 */
do_action( 'woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email );

echo "\n----------------------------------------\n\n";

/*
 * @hooked WC_Emails::order_meta() Shows order meta data.
 */
do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email );

/*
 * @hooked WC_Emails::customer_details() Shows customer details
 * @hooked WC_Emails::email_address() Shows email address
 */
do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

echo "\n\n----------------------------------------\n\n";

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ( $additional_content ) {
	echo esc_html( wp_strip_all_tags( wptexturize( $additional_content ) ) );
	echo "\n\n----------------------------------------\n\n";
}

echo wp_kses_post( apply_filters( 'woocommerce_email_footer_text', get_option( 'woocommerce_email_footer_text' ) ) );
