<?php
/**
 * Admin new order email (plain text) for pickup/delivery orders
 *
 * This template can be overridden by copying it to yourtheme/aicoso-pickup-and-delivery-for-woocommerce/emails/plain/admin-new-pickup-delivery-order.php
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce/Templates
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

echo "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n";
echo esc_html( wp_strip_all_tags( $email_heading ) );
echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

// Get order type.
$order_type         = $order->get_meta( '_aicoso_pickup_delivery_type', true );
$order_type_display = 'pickup' === $order_type ? __( 'Pickup', 'aicoso-pickup-and-delivery-for-woocommerce' ) : __( 'Delivery', 'aicoso-pickup-and-delivery-for-woocommerce' );

echo sprintf(
	/* translators: %1$s: Customer full name, %2$s: Order type (Pickup/Delivery) */
	esc_html__( 'You have received the following %2$s order from %1$s:', 'aicoso-pickup-and-delivery-for-woocommerce' ),
	esc_html( $order->get_formatted_billing_full_name() ),
	esc_html( strtolower( $order_type_display ) )
) . "\n\n";

// Display pickup or delivery specific information.
if ( 'pickup' === $order_type ) {
	$pickup_date     = $order->get_meta( '_aicoso_pickup_delivery_pickup_date', true );
	$pickup_time     = $order->get_meta( '_aicoso_pickup_delivery_pickup_time_slot', true );
	$pickup_location = $order->get_meta( '_aicoso_pickup_delivery_pickup_location', true );

	if ( $pickup_date || $pickup_time || $pickup_location ) {
		echo "\n" . esc_html__( 'PICKUP DETAILS', 'aicoso-pickup-and-delivery-for-woocommerce' ) . "\n";
		echo "----------------------------------------\n";

		if ( $pickup_date ) {
			echo esc_html__( 'Pickup Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( $pickup_date ) . "\n";
		}
		if ( $pickup_time ) {
			echo esc_html__( 'Pickup Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( $pickup_time ) . "\n";
		}
		if ( $pickup_location ) {
			echo esc_html__( 'Pickup Location:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( $pickup_location ) . "\n";
		}
		echo "----------------------------------------\n\n";
	}
} elseif ( 'delivery' === $order_type ) {
	$delivery_date = $order->get_meta( '_aicoso_pickup_delivery_delivery_date', true );
	$delivery_time = $order->get_meta( '_aicoso_pickup_delivery_delivery_time_slot', true );

	if ( $delivery_date || $delivery_time ) {
		echo "\n" . esc_html__( 'DELIVERY DETAILS', 'aicoso-pickup-and-delivery-for-woocommerce' ) . "\n";
		echo "----------------------------------------\n";

		if ( $delivery_date ) {
			echo esc_html__( 'Delivery Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( $delivery_date ) . "\n";
		}
		if ( $delivery_time ) {
			echo esc_html__( 'Delivery Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( $delivery_time ) . "\n";
		}
		echo "----------------------------------------\n\n";
	}
}

/*
 * Hook: woocommerce_email_order_details.
 * @hooked WC_Emails::order_details() Shows the order details table.
 * @hooked WC_Structured_Data::generate_order_data() Generates structured data.
 * @hooked WC_Structured_Data::output_structured_data() Outputs structured data.
 * @since 2.5.0
 */
do_action( 'woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email );

echo "\n----------------------------------------\n\n";

/*
 * Hook: woocommerce_email_order_meta.
 * @hooked WC_Emails::order_meta() Shows order meta data.
 */
do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email );

/*
 * Hook: woocommerce_email_customer_details.
 * @hooked WC_Emails::customer_details() Shows customer details
 * @hooked WC_Emails::email_address() Shows email address
 */
do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

echo "\n\n----------------------------------------\n\n";

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ( $additional_content ) {
	echo esc_html( wp_strip_all_tags( wptexturize( $additional_content ) ) );
	echo "\n\n----------------------------------------\n\n";
}

echo wp_kses_post( apply_filters( 'woocommerce_email_footer_text', get_option( 'woocommerce_email_footer_text' ) ) );
