<?php
/**
 * Pickup Confirmation Email.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/pickup-confirmation.php
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
 * @hooked WC_Emails::email_header() Output the email header
 */
do_action( 'woocommerce_email_header', $email_heading, $email ); ?>

<p>
<?php
/* translators: %s: Customer first name */
printf( esc_html__( 'Hi %s,', 'aicoso-pickup-and-delivery-for-woocommerce' ), esc_html( $order->get_billing_first_name() ) );
?>
</p>
<p><?php esc_html_e( 'Thank you for your order. Your pickup details are confirmed and summarized below.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>

<?php
// Get pickup details.
$pickup_date     = $order->get_meta( '_aicoso_pickup_delivery_pickup_date', true );
$pickup_time     = $order->get_meta( '_aicoso_pickup_delivery_pickup_time_slot', true );
$pickup_location = $order->get_meta( '_aicoso_pickup_delivery_pickup_location', true );

// Get location details if available.
$location_data = array();
if ( $pickup_location && class_exists( 'AICOSO_Pickup_Delivery_Location_Manager' ) ) {
	try {
		$location_data = AICOSO_Pickup_Delivery_Location_Manager::get_location_by_name( $pickup_location );
	} catch ( Exception $e ) {
		// Silently fail if location manager has issues.
		$location_data = array();
	}
}

if ( $pickup_date || $pickup_time || $pickup_location ) :
	?>
	<h2><?php esc_html_e( 'Pickup Details', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h2>
	<table class="td" cellspacing="0" cellpadding="6" style="width: 100%; margin: 0 0 16px;" border="1">
		<tbody>
			<?php if ( $pickup_date ) : ?>
				<tr>
					<th style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;"><?php esc_html_e( 'Pickup Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<td style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;">
					<?php
					if ( class_exists( 'AICOSO_Pickup_Delivery_Data' ) && method_exists( 'AICOSO_Pickup_Delivery_Data', 'format_date' ) ) {
						echo esc_html( AICOSO_Pickup_Delivery_Data::format_date( $pickup_date ) );
					} else {
						// Fallback to basic date formatting.
						echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $pickup_date ) ) );
					}
					?>
					</td>
				</tr>
			<?php endif; ?>
			
			<?php if ( $pickup_time ) : ?>
				<tr>
					<th style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;"><?php esc_html_e( 'Pickup Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<td style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;"><?php echo esc_html( $pickup_time ); ?></td>
				</tr>
			<?php endif; ?>
			
			<?php if ( $pickup_location ) : ?>
				<tr>
					<th style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;"><?php esc_html_e( 'Pickup Location:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<td style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;"><?php echo esc_html( $pickup_location ); ?></td>
				</tr>
				
				<?php if ( ! empty( $location_data ) && isset( $location_data['location_address'] ) && ! empty( $location_data['location_address'] ) ) : ?>
					<tr>
						<th style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;"><?php esc_html_e( 'Address:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
						<td style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;"><?php echo esc_html( $location_data['location_address'] ); ?></td>
					</tr>
				<?php endif; ?>
				
				<?php if ( ! empty( $location_data ) && isset( $location_data['location_map_url'] ) && ! empty( $location_data['location_map_url'] ) ) : ?>
					<tr>
						<th style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;"><?php esc_html_e( 'Map:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
						<td style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;">
							<a href="<?php echo esc_url( $location_data['location_map_url'] ); ?>" target="_blank"><?php esc_html_e( 'View on Google Maps', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></a>
						</td>
					</tr>
				<?php endif; ?>
			<?php endif; ?>
		</tbody>
	</table>
<?php endif; ?>

<p><?php esc_html_e( 'Please bring a valid ID when you come to pick up your order.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>

<?php
/*
 * @hooked WC_Emails::order_details() Shows the order details table.
 * @hooked WC_Structured_Data::generate_order_data() Generates structured data.
 * @hooked WC_Structured_Data::output_structured_data() Outputs structured data.
 */
do_action( 'woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email );

/*
 * @hooked WC_Emails::order_meta() Shows order meta data.
 */
do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email );

/*
 * @hooked WC_Emails::customer_details() Shows customer details
 * @hooked WC_Emails::email_address() Shows email address
 */
do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ( $additional_content ) {
	echo wp_kses_post( wpautop( wptexturize( $additional_content ) ) );
}

/*
 * @hooked WC_Emails::email_footer() Output the email footer
 */
do_action( 'woocommerce_email_footer', $email );