<?php
/**
 * Delivery details for emails.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/delivery-details.php
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get delivery details.
$delivery_date = $order->get_meta( '_aicoso_pickup_delivery_delivery_date', true );
$delivery_time = $order->get_meta( '_aicoso_pickup_delivery_delivery_time_slot', true );

// Only display if we have delivery details.
if ( ! $delivery_date && ! $delivery_time ) {
	return;
}
?>

<h2><?php esc_html_e( 'Delivery Information', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h2>
<div style="margin-bottom: 40px;">
	<table class="td" cellspacing="0" cellpadding="6" style="width: 100%; margin: 0 0 16px;" border="1">
		<tbody>
			<?php if ( $delivery_date ) : ?>
				<tr>
					<th style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;"><?php esc_html_e( 'Delivery Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<td style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;"><?php echo esc_html( AICOSO_Pickup_Delivery_Data::format_date( $delivery_date ) ); ?></td>
				</tr>
			<?php endif; ?>
			
			<?php if ( $delivery_time ) : ?>
				<tr>
					<th style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;"><?php esc_html_e( 'Delivery Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<td style="text-align: left; border: 1px solid #e5e5e5; padding: 12px;"><?php echo esc_html( $delivery_time ); ?></td>
				</tr>
			<?php endif; ?>
		</tbody>
	</table>
</div>