<?php
/**
 * Delivery confirmation email
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/delivery-confirmation.php.
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce/Templates/Emails
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

/*
 * @hooked WC_Emails::email_header() Output the email header
 */
do_action( 'woocommerce_email_header', $email_heading, $email ); ?>

<p>
<?php
/* translators: %s: Customer first name */
printf( esc_html__( 'Hi %s,', 'aicoso-pickup-and-delivery-for-woocommerce' ), esc_html( $order->get_billing_first_name() ) );
?>
</p>

<p><?php esc_html_e( 'Your order has been confirmed for delivery. Here are the details:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>

<h2><?php esc_html_e( 'Delivery Information', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h2>

<table class="td" cellspacing="0" cellpadding="6" style="width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; margin-bottom: 40px;" border="1">
	<tbody>
		<?php
		$delivery_date = $order->get_meta( '_aicoso_pickup_delivery_delivery_date', true );
		$delivery_time = $order->get_meta( '_aicoso_pickup_delivery_delivery_time_slot', true );
		?>
		
		<?php if ( $delivery_date ) : ?>
		<tr>
			<th class="td" scope="row" style="text-align:left;"><?php esc_html_e( 'Delivery Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
			<td class="td" style="text-align:left;"><?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $delivery_date ) ) ); ?></td>
		</tr>
		<?php endif; ?>
		
		<?php if ( $delivery_time ) : ?>
		<tr>
			<th class="td" scope="row" style="text-align:left;"><?php esc_html_e( 'Delivery Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
			<td class="td" style="text-align:left;"><?php echo esc_html( ucfirst( str_replace( '_', ' ', $delivery_time ) ) ); ?></td>
		</tr>
		<?php endif; ?>
		
		<tr>
			<th class="td" scope="row" style="text-align:left;"><?php esc_html_e( 'Delivery Address:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
			<td class="td" style="text-align:left;">
				<?php echo wp_kses_post( $order->get_formatted_shipping_address() ); ?>
				<?php if ( $order->get_shipping_phone() ) : ?>
					<br/><?php echo esc_html( $order->get_shipping_phone() ); ?>
				<?php endif; ?>
			</td>
		</tr>
	</tbody>
</table>

<?php
/*
 * @hooked WC_Emails::order_details() Shows the order details table.
 * @hooked WC_Structured_Data::generate_order_data() Generates structured data.
 * @hooked WC_Structured_Data::output_structured_data() Outputs structured data.
 * @since 2.5.0
 */
do_action( 'woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email );

/*
 * @hooked WC_Emails::order_meta() Shows order meta data.
 */
do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email );

/*
 * @hooked WC_Emails::customer_details() Shows customer details
 * @hooked WC_Emails::email_address() Shows email address
 */
do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ( $additional_content ) {
	echo wp_kses_post( wpautop( wptexturize( $additional_content ) ) );
}

/*
 * @hooked WC_Emails::email_footer() Output the email footer
 */
do_action( 'woocommerce_email_footer', $email );