<?php
/**
 * Admin new order email for pickup/delivery orders
 *
 * This template can be overridden by copying it to yourtheme/aicoso-pickup-and-delivery-for-woocommerce/emails/admin-new-pickup-delivery-order.php
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce/Templates
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

// Get order type.
$order_type         = $order->get_meta( '_aicoso_pickup_delivery_type', true );
$order_type_display = 'pickup' === $order_type ? __( 'Pickup', 'aicoso-pickup-and-delivery-for-woocommerce' ) : __( 'Delivery', 'aicoso-pickup-and-delivery-for-woocommerce' );

/*
 * Hook: woocommerce_email_header.
 * @hooked WC_Emails::email_header() Output the email header.
 */
do_action( 'woocommerce_email_header', $email_heading, $email ); ?>

<p>
<?php
printf(
	/* translators: %1$s: Customer full name, %2$s: Order type (Pickup/Delivery) */
	esc_html__( 'You have received the following %2$s order from %1$s:', 'aicoso-pickup-and-delivery-for-woocommerce' ),
	esc_html( $order->get_formatted_billing_full_name() ),
	esc_html( strtolower( $order_type_display ) )
);
?>
</p>

<?php
// Display pickup or delivery specific information before order details.
if ( 'pickup' === $order_type ) {
	$pickup_date     = $order->get_meta( '_aicoso_pickup_delivery_pickup_date', true );
	$pickup_time     = $order->get_meta( '_aicoso_pickup_delivery_pickup_time_slot', true );
	$pickup_location = $order->get_meta( '_aicoso_pickup_delivery_pickup_location', true );

	if ( $pickup_date || $pickup_time || $pickup_location ) {
		?>
		<h3><?php esc_html_e( 'Pickup Details', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h3>
		<table cellspacing="0" cellpadding="6" style="width: 100%; border: 1px solid #eee;" border="1">
			<?php if ( $pickup_date ) : ?>
			<tr>
				<th style="text-align:left; border: 1px solid #eee;"><?php esc_html_e( 'Pickup Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				<td style="text-align:left; border: 1px solid #eee;"><?php echo esc_html( $pickup_date ); ?></td>
			</tr>
			<?php endif; ?>
			<?php if ( $pickup_time ) : ?>
			<tr>
				<th style="text-align:left; border: 1px solid #eee;"><?php esc_html_e( 'Pickup Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				<td style="text-align:left; border: 1px solid #eee;"><?php echo esc_html( $pickup_time ); ?></td>
			</tr>
			<?php endif; ?>
			<?php if ( $pickup_location ) : ?>
			<tr>
				<th style="text-align:left; border: 1px solid #eee;"><?php esc_html_e( 'Pickup Location:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				<td style="text-align:left; border: 1px solid #eee;"><?php echo esc_html( $pickup_location ); ?></td>
			</tr>
			<?php endif; ?>
		</table>
		<?php
	}
} elseif ( 'delivery' === $order_type ) {
	$delivery_date = $order->get_meta( '_aicoso_pickup_delivery_delivery_date', true );
	$delivery_time = $order->get_meta( '_aicoso_pickup_delivery_delivery_time_slot', true );

	if ( $delivery_date || $delivery_time ) {
		?>
		<h3><?php esc_html_e( 'Delivery Details', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h3>
		<table cellspacing="0" cellpadding="6" style="width: 100%; border: 1px solid #eee;" border="1">
			<?php if ( $delivery_date ) : ?>
			<tr>
				<th style="text-align:left; border: 1px solid #eee;"><?php esc_html_e( 'Delivery Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				<td style="text-align:left; border: 1px solid #eee;"><?php echo esc_html( $delivery_date ); ?></td>
			</tr>
			<?php endif; ?>
			<?php if ( $delivery_time ) : ?>
			<tr>
				<th style="text-align:left; border: 1px solid #eee;"><?php esc_html_e( 'Delivery Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				<td style="text-align:left; border: 1px solid #eee;"><?php echo esc_html( $delivery_time ); ?></td>
			</tr>
			<?php endif; ?>
		</table>
		<?php
	}
}
?>

<?php
/*
 * Hook: woocommerce_email_order_details.
 * @hooked WC_Emails::order_details() Shows the order details table.
 * @hooked WC_Structured_Data::generate_order_data() Generates structured data.
 * @hooked WC_Structured_Data::output_structured_data() Outputs structured data.
 * @since 2.5.0
 */
do_action( 'woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email );

/*
 * Hook: woocommerce_email_order_meta.
 * @hooked WC_Emails::order_meta() Shows order meta data.
 */
do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email );

/*
 * Hook: woocommerce_email_customer_details.
 * @hooked WC_Emails::customer_details() Shows customer details
 * @hooked WC_Emails::email_address() Shows email address
 */
do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ( $additional_content ) {
	echo wp_kses_post( wpautop( wptexturize( $additional_content ) ) );
}

/*
 * Hook: woocommerce_email_footer.
 * @hooked WC_Emails::email_footer() Output the email footer.
 */
do_action( 'woocommerce_email_footer', $email );