<?php
/**
 * Pickup options for checkout.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/pickup-options.php
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

// Get settings.
$settings                 = AICOSO_Pickup_Delivery_Data::get_settings();
$enable_pickup_date       = isset( $settings['enable_pickup_date'] ) ? $settings['enable_pickup_date'] : 'yes';
$enable_pickup_time_slots = isset( $settings['enable_pickup_time_slots'] ) ? $settings['enable_pickup_time_slots'] : 'yes';

// Only show this section if pickup date is enabled or time slots are enabled.
if ( 'yes' !== $enable_pickup_date && 'yes' !== $enable_pickup_time_slots ) {
	return;
}
?>

<div class="aicoso-pickup-delivery-pickup-options-inner">
	<h4><?php esc_html_e( 'Pickup Details', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h4>

	<?php if ( 'yes' === $enable_pickup_date ) : ?>
		<div class="aicoso-pickup-delivery-date-picker">
			<p class="form-row form-row-wide">
				<label for="aicoso-pickup-delivery-pickup-date"><?php esc_html_e( 'Pickup Date', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?> <span class="required">*</span></label>
				<span class="woocommerce-input-wrapper aicoso-pickup-delivery-date-wrapper">
					<input type="text" id="aicoso-pickup-delivery-pickup-date" name="aicoso_pickup_delivery_pickup_date" class="input-text" placeholder="<?php esc_attr_e( 'Select date', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>" readonly required />
					<span class="aicoso-pickup-delivery-calendar-icon">📅</span>
				</span>
			</p>
		</div>
	<?php endif; ?>
	
	<div class="aicoso-pickup-delivery-location-select">
		<p class="form-row form-row-wide">
			<label for="aicoso-pickup-delivery-pickup-location"><?php esc_html_e( 'Pickup Location', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?> <span class="required">*</span></label>
			<select id="aicoso-pickup-delivery-pickup-location" name="aicoso_pickup_delivery_pickup_location" class="select" required disabled>
				<option value=""><?php esc_html_e( 'Select a date first', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
			</select>
		</p>
	</div>
	
	<div class="aicoso-pickup-delivery-location-details" style="display: none;">
		<p class="pickup-address"></p>
		<p class="pickup-map-link"></p>
	</div>

	<?php if ( 'yes' === $enable_pickup_time_slots ) : ?>
		<div class="aicoso-pickup-delivery-time-select">
			<p class="form-row">
				<label for="aicoso-pickup-delivery-pickup-time-slot"><?php esc_html_e( 'Select Pickup Time', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?> <span class="required">*</span></label>
				<select id="aicoso-pickup-delivery-pickup-time-slot" name="aicoso_pickup_delivery_pickup_time_slot" class="select" required disabled>
					<option value=""><?php esc_html_e( 'Select a date first', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
				</select>
			</p>
		</div>
	<?php endif; ?>
</div>

<?php
/**
 * NOTE: The pickup date picker functionality has been moved to:
 * assets/js/aicoso-pickup-delivery-checkout.js
 *
 * This was done to comply with WordPress coding standards which prohibit
 * inline <script> tags in template files. All JavaScript functionality
 * is now properly enqueued through the frontend class and localized
 * for internationalization support.
 */
?>