<?php
/**
 * Main checkout form template for pickup and delivery options.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-pickup-delivery.php
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

// Get settings.
$settings         = AICOSO_Pickup_Delivery_Data::get_settings();
$enable_selection = isset( $settings['enable_order_type_selection'] ) ? $settings['enable_order_type_selection'] : 'yes';
$default_type     = isset( $settings['default_order_type'] ) ? $settings['default_order_type'] : 'delivery';
?>

<div class="aicoso-pickup-delivery-form-wrapper">
	<h3><?php esc_html_e( 'Delivery & Pickup Options', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h3>

	<?php if ( 'yes' === $enable_selection ) : ?>
		<?php
		// Include the order type selector.
		wc_get_template(
			'checkout/delivery-pickup-selector.php',
			array(
				'default_type' => $default_type,
			),
			'aicoso-pickup-and-delivery-for-woocommerce/',
			AICOSO_PICKUP_DELIVERY_PLUGIN_PATH . 'templates/'
		);
		?>
	<?php else : ?>
		<div class="aicoso-pickup-delivery-options-wrapper">
			<?php if ( 'delivery' === $default_type ) : ?>
				<div class="aicoso-pickup-delivery-delivery-options">
					<?php
					// Include delivery options template.
					wc_get_template(
						'checkout/delivery-options.php',
						array(),
						'aicoso-pickup-and-delivery-for-woocommerce/',
						AICOSO_PICKUP_DELIVERY_PLUGIN_PATH . 'templates/'
					);
					?>
				</div>
			<?php else : ?>
				<div class="aicoso-pickup-delivery-pickup-options">
					<?php
					// Include pickup options template.
					wc_get_template(
						'checkout/pickup-options.php',
						array(),
						'aicoso-pickup-and-delivery-for-woocommerce/',
						AICOSO_PICKUP_DELIVERY_PLUGIN_PATH . 'templates/'
					);
					?>
				</div>
			<?php endif; ?>
		</div>
		
		<input type="hidden" id="aicoso_pickup_delivery_type" name="aicoso_pickup_delivery_type" value="<?php echo esc_attr( $default_type ); ?>" />
	<?php endif; ?>
</div>

<?php
// Include JavaScript parameters for AJAX.
wc_enqueue_js(
	"
    var aicoso_pickup_delivery_params = {
        ajax_url: '" . esc_js( admin_url( 'admin-ajax.php' ) ) . "',
        nonce: '" . esc_js( wp_create_nonce( 'aicoso_pickup_delivery_nonce' ) ) . "'
    };
"
);
?>

<!-- Styles moved to assets/css/aicoso-pickup-delivery-frontend.css for WordPress standards compliance -->