<?php
/**
 * Delivery/Pickup selector for checkout.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/delivery-pickup-selector.php
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

// Prevent rendering if already rendered.
global $aicoso_pickup_delivery_selector_rendered;
if ( ! empty( $aicoso_pickup_delivery_selector_rendered ) ) {
	return;
}
$aicoso_pickup_delivery_selector_rendered = true;

// Ensure CSS is loaded.
wp_enqueue_style( 'aicoso-pickup-delivery-frontend', plugin_dir_url( dirname( __DIR__, 1 ) ) . 'assets/css/aicoso-pickup-delivery-frontend.css', array(), '1.0.0' );

// Get saved value if user has already made a selection (for example when returning to checkout page).
$selected_type = WC()->session->get( 'aicoso_pickup_delivery_type' );

// Use provided default if no selection has been made yet.
if ( empty( $selected_type ) ) {
	$selected_type = $default_type;
}
?>

<!-- Styles moved to assets/css/aicoso-pickup-delivery-frontend.css for WordPress standards compliance -->

<div id="aicoso-pickup-delivery-main-selector" class="aicoso-pickup-delivery-selector-wrapper">
	<div class="aicoso-pickup-delivery-selector">
		<p class="form-row form-row-wide">
			<label for="aicoso-pickup-delivery-type-select"><?php esc_html_e( 'Delivery Method', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?> <span class="required">*</span></label>
			<select id="aicoso-pickup-delivery-type-select" name="aicoso_pickup_delivery_type_selector" class="select aicoso-pickup-delivery-select">
				<option value="delivery" <?php selected( $selected_type, 'delivery' ); ?>><?php esc_html_e( 'Delivery', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
				<option value="pickup" <?php selected( $selected_type, 'pickup' ); ?>><?php esc_html_e( 'Pickup', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
			</select>
		</p>
	</div>
</div>

<div class="aicoso-pickup-delivery-options-wrapper">
	<div class="aicoso-pickup-delivery-delivery-options" style="<?php echo 'delivery' === $selected_type ? '' : 'display: none;'; ?>">
		<?php
		// Include delivery options template.
		wc_get_template(
			'checkout/delivery-options.php',
			array(),
			'aicoso-pickup-and-delivery-for-woocommerce/',
			AICOSO_PICKUP_DELIVERY_PLUGIN_PATH . 'templates/'
		);
		?>
	</div>

	<div class="aicoso-pickup-delivery-pickup-options" style="<?php echo 'pickup' === $selected_type ? '' : 'display: none;'; ?>">
		<?php
		// Include pickup options template.
		wc_get_template(
			'checkout/pickup-options.php',
			array(),
			'aicoso-pickup-and-delivery-for-woocommerce/',
			AICOSO_PICKUP_DELIVERY_PLUGIN_PATH . 'templates/'
		);
		?>
	</div>
</div>

<!-- JavaScript functionality moved to assets/js/aicoso-pickup-delivery-checkout.js for WordPress standards compliance -->