<?php
/**
 * The My Account integration functionality of the plugin.
 *
 * @link       https://example.com
 * @since      1.0.0
 * @package    aicoso_pickup_delivery
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The My Account integration class.
 *
 * Handles the integration with WooCommerce My Account page to display
 * delivery/pickup details for orders.
 *
 * @since      1.0.0
 * @package    aicoso_pickup_delivery
 * @author     Your Name
 */
class AICOSO_Pickup_Delivery_My_Account {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param    string $plugin_name       The name of this plugin.
	 * @param    string $version           The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	/**
	 * Display delivery/pickup details on the order view page in My Account
	 *
	 * @since    1.0.0
	 * @param    WC_Order $order    The order object.
	 */
	public function display_delivery_pickup_details( $order ) {
		if ( ! $order instanceof WC_Order ) {
			return;
		}

		$order_id   = $order->get_id();
		$order_type = AICOSO_Pickup_Delivery_Data::get_order_type( $order );

		// Only proceed if this is a delivery or pickup order.
		if ( ! in_array( $order_type, array( 'delivery', 'pickup' ), true ) ) {
			return;
		}

		// Load the appropriate template based on order type.
		if ( 'delivery' === $order_type ) {
			wc_get_template(
				'myaccount/delivery-details.php',
				array( 'order' => $order ),
				'aicoso-pickup-and-delivery-for-woocommerce/',
				AICOSO_PICKUP_DELIVERY_PLUGIN_PATH . 'templates/'
			);
		} else {
			wc_get_template(
				'myaccount/pickup-details.php',
				array( 'order' => $order ),
				'aicoso-pickup-and-delivery-for-woocommerce/',
				AICOSO_PICKUP_DELIVERY_PLUGIN_PATH . 'templates/'
			);
		}
	}
}
