<?php
/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://example.com
 * @since      1.0.0
 * @package    aicoso_pickup_delivery
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two hooks for
 * enqueuing the public-facing stylesheet and JavaScript.
 *
 * @package    aicoso_pickup_delivery
 * @author     Your Name
 */
class AICOSO_Pickup_Delivery_Frontend {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param    string $plugin_name       The name of the plugin.
	 * @param    string $version           The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {
		// Use local jQuery UI CSS instead of CDN to comply with WordPress plugin guidelines.
		wp_enqueue_style( 'jquery-ui-style', plugin_dir_url( dirname( __DIR__, 1 ) ) . 'assets/css/jquery-ui.min.css', array(), '1.12.1' );
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( dirname( __DIR__, 1 ) ) . 'assets/css/aicoso-pickup-delivery-frontend.css', array(), $this->version, 'all' );
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {
		wp_enqueue_script( 'jquery-ui-datepicker' );

		// Enqueue checkout-specific JavaScript (moved from inline scripts for WordPress standards compliance).
		wp_enqueue_script(
			$this->plugin_name . '-checkout',
			plugin_dir_url( dirname( __DIR__, 1 ) ) . 'assets/js/aicoso-pickup-delivery-checkout.js',
			array( 'jquery', 'jquery-ui-datepicker' ),
			$this->version,
			true
		);

		// Keep the original minified file for any remaining functionality.
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( dirname( __DIR__, 1 ) ) . 'assets/js/aicoso-pickup-delivery-frontend.min.js', array( 'jquery', 'jquery-ui-datepicker' ), $this->version, false );

		$settings = AICOSO_Pickup_Delivery_Data::get_settings();

		// Localized script data for frontend.
		wp_localize_script(
			$this->plugin_name,
			'aicoso_pickup_delivery_params',
			array(
				'ajax_url'                    => admin_url( 'admin-ajax.php' ),
				'nonce'                       => wp_create_nonce( 'aicoso_pickup_delivery_nonce' ),
				'enable_order_type_selection' => isset( $settings['enable_order_type_selection'] ) ? $settings['enable_order_type_selection'] : 'yes',
				'default_order_type'          => isset( $settings['default_order_type'] ) ? $settings['default_order_type'] : 'delivery',
				'i18n'                        => array(
					// General strings.
					'select_date_first'        => __( 'Please select a date first', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'select_time_slot'         => __( 'Select a time slot', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'loading_time_slots'       => __( 'Loading time slots...', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'no_time_slots'            => __( 'No time slots available', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'error_loading_time_slots' => __( 'Error loading time slots', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'select_location'          => __( 'Select a pickup location', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'loading_locations'        => __( 'Loading locations...', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'no_locations'             => __( 'No pickup locations available', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'error_loading_locations'  => __( 'Error loading locations', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'not_available'            => __( 'Not available', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'available'                => __( 'Available', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'address_label'            => __( 'Address:', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'view_on_maps'             => __( 'View on Google Maps', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'date_format'              => __( 'yy-mm-dd', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					// Delivery-specific strings.
					'delivery_not_available'   => __( 'Not available for delivery', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'delivery_available'       => __( 'Available for delivery', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'delivery_loading_slots'   => __( 'Loading delivery time slots...', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'delivery_select_slot'     => __( 'Select a delivery time slot', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'delivery_no_slots'        => __( 'No delivery time slots available', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'delivery_error_loading'   => __( 'Error loading delivery time slots', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					// Pickup-specific strings.
					'pickup_not_available'     => __( 'Not available for pickup', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'pickup_available'         => __( 'Available for pickup', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'pickup_loading_slots'     => __( 'Loading pickup time slots...', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'pickup_select_slot'       => __( 'Select a pickup time slot', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'pickup_no_slots'          => __( 'No pickup time slots available', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					'pickup_error_loading'     => __( 'Error loading pickup time slots', 'aicoso-pickup-and-delivery-for-woocommerce' ),
				),
			)
		);
	}

	/**
	 * Add the delivery/pickup form to the checkout page
	 *
	 * @since    1.0.0
	 */
	public function add_delivery_pickup_form() {
		wc_get_template(
			'checkout/form-pickup-delivery.php',
			array(),
			'aicoso-pickup-and-delivery-for-woocommerce/',
			AICOSO_PICKUP_DELIVERY_PLUGIN_PATH . 'templates/'
		);
	}

	/**
	 * AJAX handler for saving the selected order type in session
	 *
	 * @since    1.0.0
	 */
	public function save_type_in_session() {
		// Check nonce.
		check_ajax_referer( 'aicoso_pickup_delivery_nonce', 'nonce' );

		$type = isset( $_POST['type'] ) ? sanitize_text_field( wp_unslash( $_POST['type'] ) ) : '';

		if ( ! in_array( $type, array( 'delivery', 'pickup' ), true ) ) {
			wp_send_json_error( array( 'message' => __( 'Invalid order type', 'aicoso-pickup-and-delivery-for-woocommerce' ) ) );
			return;
		}

		// Save to session.
		WC()->session->set( 'aicoso_pickup_delivery_type', $type );

		wp_send_json_success();
	}
}
