<?php
/**
 * Pickup details for plain text emails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/plain/pickup-details.php
 *
 * @package    aicoso_pickup_delivery
 * @version    1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get pickup details.
$pickup_date     = $order->get_meta( '_aicoso_pickup_delivery_pickup_date', true );
$pickup_time     = $order->get_meta( '_aicoso_pickup_delivery_pickup_time_slot', true );
$pickup_location = $order->get_meta( '_aicoso_pickup_delivery_pickup_location', true );

// Get location details if available.
$location_data = array();
if ( $pickup_location ) {
	$location_data = AICOSO_Pickup_Delivery_Location_Manager::get_location_by_name( $pickup_location );
}

// Only display if we have pickup details.
if ( ! $pickup_date && ! $pickup_time && ! $pickup_location ) {
	return;
}

echo esc_html__( 'PICKUP INFORMATION', 'aicoso-pickup-and-delivery-for-woocommerce' ) . "\n";
echo "-----------------------------------------------------------\n";

if ( $pickup_date ) {
	echo esc_html__( 'Pickup Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( AICOSO_Pickup_Delivery_Data::format_date( $pickup_date ) ) . "\n";
}

if ( $pickup_time ) {
	echo esc_html__( 'Pickup Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( $pickup_time ) . "\n";
}

if ( $pickup_location ) {
	echo esc_html__( 'Pickup Location:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( $pickup_location ) . "\n";

	if ( ! empty( $location_data ) && isset( $location_data['location_address'] ) && ! empty( $location_data['location_address'] ) ) {
		echo esc_html__( 'Address:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( $location_data['location_address'] ) . "\n";
	}

	if ( ! empty( $location_data ) && isset( $location_data['location_map_url'] ) && ! empty( $location_data['location_map_url'] ) ) {
		echo esc_html__( 'Map:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_url( $location_data['location_map_url'] ) . "\n";
	}
}

echo "\n";
