<?php
/**
 * Delivery details for plain text emails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/plain/delivery-details.php
 *
 * @package    aicoso_pickup_delivery
 * @version    1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get delivery details.
$delivery_date = $order->get_meta( '_aicoso_pickup_delivery_delivery_date', true );
$delivery_time = $order->get_meta( '_aicoso_pickup_delivery_delivery_time_slot', true );

// Only display if we have delivery details.
if ( ! $delivery_date && ! $delivery_time ) {
	return;
}

echo esc_html__( 'DELIVERY INFORMATION', 'aicoso-pickup-and-delivery-for-woocommerce' ) . "\n";
echo "-----------------------------------------------------------\n";

if ( $delivery_date ) {
	echo esc_html__( 'Delivery Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( AICOSO_Pickup_Delivery_Data::format_date( $delivery_date ) ) . "\n";
}

if ( $delivery_time ) {
	echo esc_html__( 'Delivery Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ) . ' ' . esc_html( $delivery_time ) . "\n";
}

echo "\n";
