<?php
/**
 * Minimal fallback WP_REST_Exception for early bootstrap contexts.
 *
 * This file provides a tiny fallback implementation only when the core
 * `WP_REST_Exception` class is not available. It mirrors the minimal
 * structure needed by the plugin so code can throw the exception safely.
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'WP_REST_Exception' ) ) {
	/**
	 * Minimal fallback WP_REST_Exception for early load contexts.
	 */
	class WP_REST_Exception extends Exception {
		/**
		 * Exception additional data.
		 *
		 * @var array
		 */
		protected $data;

		/**
		 * Constructor.
		 *
		 * @param string $code Error code.
		 * @param string $message Error message.
		 * @param array  $data Optional additional data.
		 */
		public function __construct( $code = '', $message = '', $data = array() ) {
			parent::__construct( $message );
			$this->code = $code;
			$this->data = $data;
		}

		/**
		 * Get associated data.
		 *
		 * @return array
		 */
		public function get_data() {
			return $this->data;
		}
	}
}
