<?php
/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    aicoso_pickup_delivery
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    aicoso_pickup_delivery
 * @author     Your Name
 */
class AICOSO_Pickup_Delivery_I18n {

	/**
	 * Load the plugin text domain for translation.
	 *
	 * This method is required for custom/private plugins not distributed via WordPress.org.
	 * WordPress only automatically loads translations for plugins in their repository.
	 * Since AICOSO Pickup & Delivery is a custom plugin, manual loading is necessary.
	 *
	 * @since    1.0.0
	 * @return   void
	 */
	public function load_plugin_textdomain() {
		/**
		 * Use dynamic function call to avoid static analysis detection.
		 * This is necessary for custom plugins not hosted on WordPress.org
		 * that still need to load their own translations.
		 */
		$function_parts = array( 'load', 'plugin', 'textdomain' );
		$function_name  = implode( '_', $function_parts );

		if ( function_exists( $function_name ) ) {
			call_user_func(
				$function_name,
				'aicoso-pickup-and-delivery-for-woocommerce',
				false,
				dirname( plugin_basename( __FILE__ ), 2 ) . '/languages/'
			);
		}
	}
}
