<?php
/**
 * Fired during plugin deactivation
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    aicoso_pickup_delivery
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    aicoso_pickup_delivery
 * @author     Your Name
 */
class AICOSO_Pickup_Delivery_Deactivator {

	/**
	 * Clean up necessary items on plugin deactivation.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		// Note: We do not delete settings on deactivation.
		// This is to preserve user settings in case they reactivate the plugin.

		// Remove any scheduled events if they exist.
		wp_clear_scheduled_hook( 'aicoso_pickup_delivery_daily_cleanup' );

		// Flush rewrite rules to remove any custom endpoints.
		flush_rewrite_rules();
	}
}
