<?php
/**
 * Fired during plugin activation
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    aicoso_pickup_delivery
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    aicoso_pickup_delivery
 * @author     Your Name
 */
class AICOSO_Pickup_Delivery_Activator {

	/**
	 * Initialize default settings on plugin activation.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
		// Set default option values if they don't exist.
		if ( ! get_option( 'aicoso_pickup_delivery_settings' ) ) {
			$default_settings = array(
				// Order settings.
				'enable_order_type_selection' => 'yes',
				'default_order_type'          => 'delivery',
				'max_orders_per_day'          => 50,

				// Delivery settings.
				'enable_delivery_date'        => 'yes',
				'max_delivery_per_day'        => 25,
				'delivery_days'               => array( 1, 2, 3, 4, 5 ), // Monday to Friday.
				'delivery_lead_time'          => 1, // Minimum lead time for delivery in days.

				// Pickup settings.
				'enable_pickup_date'          => 'yes',
				'max_pickup_per_day'          => 25,
				'pickup_days'                 => array( 1, 2, 3, 4, 5 ), // Monday to Friday.
				'pickup_lead_time'            => 1, // Minimum lead time for pickup in days.

				// Time slot settings.
				'enable_delivery_time_slots'  => 'yes',
				'enable_pickup_time_slots'    => 'yes',
			);

			update_option( 'aicoso_pickup_delivery_settings', $default_settings );
		}

		// Set default time slots if they don't exist.
		if ( ! get_option( 'aicoso_pickup_delivery_delivery_time_slots' ) ) {
			$default_delivery_time_slots = array(
				array(
					'slot_name'  => 'Morning (9:00 AM - 12:00 PM)',
					'start_time' => '09:00',
					'end_time'   => '12:00',
					'max_orders' => 10,
				),
				array(
					'slot_name'  => 'Afternoon (12:00 PM - 3:00 PM)',
					'start_time' => '12:00',
					'end_time'   => '15:00',
					'max_orders' => 10,
				),
				array(
					'slot_name'  => 'Evening (3:00 PM - 6:00 PM)',
					'start_time' => '15:00',
					'end_time'   => '18:00',
					'max_orders' => 10,
				),
			);

			update_option( 'aicoso_pickup_delivery_delivery_time_slots', $default_delivery_time_slots );
		}

		// Set default pickup time slots if they don't exist.
		if ( ! get_option( 'aicoso_pickup_delivery_pickup_time_slots' ) ) {
			$default_pickup_time_slots = array(
				array(
					'slot_name'  => 'Morning (9:00 AM - 12:00 PM)',
					'start_time' => '09:00',
					'end_time'   => '12:00',
					'max_orders' => 10,
				),
				array(
					'slot_name'  => 'Afternoon (12:00 PM - 3:00 PM)',
					'start_time' => '12:00',
					'end_time'   => '15:00',
					'max_orders' => 10,
				),
				array(
					'slot_name'  => 'Evening (3:00 PM - 6:00 PM)',
					'start_time' => '15:00',
					'end_time'   => '18:00',
					'max_orders' => 10,
				),
			);

			update_option( 'aicoso_pickup_delivery_pickup_time_slots', $default_pickup_time_slots );
		}

		// Set default pickup locations if they don't exist.
		if ( ! get_option( 'aicoso_pickup_delivery_pickup_locations' ) ) {
			$default_pickup_locations = array(
				array(
					'location_name'    => 'Main Store',
					'location_address' => '123 Example Street, City, 12345',
					'location_map_url' => 'https://maps.google.com/?q=123+Example+Street',
					'location_email'   => get_option( 'admin_email' ),
					'max_orders'       => 25,
				),
			);

			update_option( 'aicoso_pickup_delivery_pickup_locations', $default_pickup_locations );
		}

		// Create blackout dates option.
		if ( ! get_option( 'aicoso_pickup_delivery_blackout_dates' ) ) {
			update_option( 'aicoso_pickup_delivery_blackout_dates', array() );
		}

		// Set capabilities for admin users.
		$admin_role = get_role( 'administrator' );
		if ( $admin_role ) {
			$admin_role->add_cap( 'manage_aicoso_pickup_delivery' );
		}

		// Flush rewrite rules to ensure any custom endpoints work.
		flush_rewrite_rules();
	}
}
