<?php
/**
 * Admin settings page template
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    aicoso_pickup_delivery
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Get current tab.
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Admin page tab navigation
$aicoso_current_tab = isset( $_GET['tab'] ) ? sanitize_text_field( wp_unslash( $_GET['tab'] ) ) : 'general';
?>

<div class="wrap aicoso-pickup-delivery-settings">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
	
	<h2 class="nav-tab-wrapper">
		<?php foreach ( $tabs as $aicoso_tab_id => $aicoso_tab_name ) : ?>
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=aicoso-pickup-delivery-settings&tab=' . $aicoso_tab_id ) ); ?>" class="nav-tab <?php echo esc_html( $aicoso_tab_id === $aicoso_current_tab ? 'nav-tab-active' : '' ); ?>">
				<?php echo esc_html( $aicoso_tab_name ); ?>
			</a>
		<?php endforeach; ?>
	</h2>
	
	<form method="post" action="">
		<?php wp_nonce_field( 'aicoso_pickup_delivery_save_settings' ); ?>
		<input type="hidden" name="save_settings" value="1" />
		
		<?php
		// Include the tab-specific template.
		$aicoso_template_file = plugin_dir_path( __DIR__ ) . 'partials/admin-settings-' . $aicoso_current_tab . '.php';
		if ( file_exists( $aicoso_template_file ) ) {
			include_once $aicoso_template_file;
		}
		?>
		
	</form>
</div>