<?php
/**
 * Time Slot Settings Admin Section.
 *
 * This file handles the display and management of delivery and pickup time slot settings
 * for the Aicoso Pickup & Delivery WooCommerce plugin.
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 * @subpackage Admin/Settings
 * @version 1.0.0
 * @author  Aicoso
 * @license GPL-2.0+
 *
 * Description:
 * - Allows admin users to enable/disable delivery and pickup time slots.
 * - Provides options to add, edit, and delete time slots.
 * - Uses AICOSO_Pickup_Delivery_Data for fetching and formatting saved time slot data.
 * - Includes jQuery interactions for UI toggle and inline editing.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<h2><?php esc_html_e( 'Time Slot Settings', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
<?php wp_nonce_field( 'aicoso_pickup_delivery_settings', 'aicoso_pickup_delivery_nonce' ); ?>
</h2>
		<p><?php esc_html_e( 'Configure the time slots for delivery and pickup.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
		
		<!-- Delivery Time Slots -->
		<h3><?php esc_html_e( 'Delivery Time Slots', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h3>
		
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="enable_delivery_time_slots"><?php esc_html_e( 'Enable Delivery Time Slots', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<div class="toggle-control">
						<label class="toggle-switch">
							<input type="checkbox" id="enable_delivery_time_slots" name="enable_delivery_time_slots" value="1" <?php checked( isset( $settings['enable_delivery_time_slots'] ) && 'yes' === $settings['enable_delivery_time_slots'] ); ?> />
							<span class="toggle-slider"></span>
						</label>
						<label for="enable_delivery_time_slots" class="toggle-label">
							<?php esc_html_e( 'Allow customers to select a delivery time slot', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
						</label>
					</div>
				</td>
			</tr>
		</table>

		<div id="delivery_time_slots_container" <?php echo isset( $settings['enable_delivery_time_slots'] ) && 'yes' === $settings['enable_delivery_time_slots'] ? '' : 'style="display:none;"'; ?>>
			<h4><?php esc_html_e( 'Current Delivery Time Slots', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h4>
			
			<table class="widefat fixed striped">
				<thead>
					<tr>
						<th><?php esc_html_e( 'Time Slot Name', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
						<th><?php esc_html_e( 'Start Time', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
						<th><?php esc_html_e( 'End Time', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
						<th><?php esc_html_e( 'Max Orders', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
						<th><?php esc_html_e( 'Actions', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php $aicoso_delivery_time_slots = AICOSO_Pickup_Delivery_Data::get_delivery_time_slots(); ?>

					<?php if ( empty( $aicoso_delivery_time_slots ) ) : ?>
						<tr>
							<td colspan="5"><?php esc_html_e( 'No delivery time slots defined.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></td>
						</tr>
					<?php else : ?>
						<?php foreach ( $aicoso_delivery_time_slots as $aicoso_slot ) : ?>
							<tr class="time-slot-row" data-slot-type="delivery" data-slot-name="<?php echo esc_attr( $aicoso_slot['slot_name'] ); ?>" data-start-time="<?php echo esc_attr( $aicoso_slot['start_time'] ); ?>" data-end-time="<?php echo esc_attr( $aicoso_slot['end_time'] ); ?>" data-max-orders="<?php echo esc_attr( $aicoso_slot['max_orders'] ); ?>">
								<td><?php echo esc_html( $aicoso_slot['slot_name'] ); ?></td>
								<td><?php echo esc_html( AICOSO_Pickup_Delivery_Data::format_time( $aicoso_slot['start_time'] ) ); ?></td>
								<td><?php echo esc_html( AICOSO_Pickup_Delivery_Data::format_time( $aicoso_slot['end_time'] ) ); ?></td>
								<td><?php echo esc_html( $aicoso_slot['max_orders'] ); ?></td>
								<td>
									<button type="button" class="button button-small edit-time-slot" data-slot-type="delivery"><?php esc_html_e( 'Edit', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
									<button type="submit" name="delete_delivery_time_slot" value="<?php echo esc_attr( $aicoso_slot['slot_name'] ); ?>" class="button button-small"><?php esc_html_e( 'Delete', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
								</td>
							</tr>
						<?php endforeach; ?>
					<?php endif; ?>
				</tbody>
			</table>
			
			<h4 id="delivery-form-title"><?php esc_html_e( 'Add New Delivery Time Slot', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h4>
			
			<table class="form-table">
				<input type="hidden" id="edit_delivery_slot_original" name="edit_delivery_slot_original" value="" />
				<tr>
					<th scope="row">
						<label for="delivery_slot_name"><?php esc_html_e( 'Time Slot Name', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
					</th>
					<td>
						<input type="text" id="delivery_slot_name" name="delivery_slot_name" class="regular-text" placeholder="<?php esc_html_e( 'e.g., Morning (9:00 AM - 12:00 PM)', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>" />
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="delivery_start_time"><?php esc_html_e( 'Start Time', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
					</th>
					<td>
						<input type="time" id="delivery_start_time" name="delivery_start_time" class="regular-text" />
						<p class="description"><?php esc_html_e( 'The start time for this slot (24-hour format).', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="delivery_end_time"><?php esc_html_e( 'End Time', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
					</th>
					<td>
						<input type="time" id="delivery_end_time" name="delivery_end_time" class="regular-text" />
						<p class="description"><?php esc_html_e( 'The end time for this slot (24-hour format).', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="delivery_max_orders"><?php esc_html_e( 'Maximum Orders', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
					</th>
					<td>
						<input type="number" id="delivery_max_orders" name="delivery_max_orders" min="1" max="1000" value="10" class="regular-text" />
						<p class="description"><?php esc_html_e( 'The maximum number of delivery orders allowed for this time slot.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"></th>
					<td>
						<button type="submit" name="add_delivery_time_slot" id="add_delivery_button" class="button button-primary"><?php esc_html_e( 'Add Time Slot', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
						<button type="submit" name="update_delivery_time_slot" id="update_delivery_button" class="button button-primary" style="display:none;"><?php esc_html_e( 'Update Time Slot', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
						<button type="button" id="cancel_delivery_edit" class="button" style="display:none;"><?php esc_html_e( 'Cancel', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
					</td>
				</tr>
			</table>
		</div>
		
		<!-- Pickup Time Slots -->
		<h3><?php esc_html_e( 'Pickup Time Slots', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h3>
		
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="enable_pickup_time_slots"><?php esc_html_e( 'Enable Pickup Time Slots', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<div class="toggle-control">
						<label class="toggle-switch">
							<input type="checkbox" id="enable_pickup_time_slots" name="enable_pickup_time_slots" value="1" <?php checked( isset( $settings['enable_pickup_time_slots'] ) && 'yes' === $settings['enable_pickup_time_slots'] ); ?> />
							<span class="toggle-slider"></span>
						</label>
						<label for="enable_pickup_time_slots" class="toggle-label">
							<?php esc_html_e( 'Allow customers to select a pickup time slot', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
						</label>
					</div>
				</td>
			</tr>
		</table>

		<div id="pickup_time_slots_container" <?php echo isset( $settings['enable_pickup_time_slots'] ) && 'yes' === $settings['enable_pickup_time_slots'] ? '' : 'style="display:none;"'; ?>>
			<h4><?php esc_html_e( 'Current Pickup Time Slots', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h4>
			
			<table class="widefat fixed striped">
				<thead>
					<tr>
						<th><?php esc_html_e( 'Time Slot Name', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
						<th><?php esc_html_e( 'Start Time', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
						<th><?php esc_html_e( 'End Time', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
						<th><?php esc_html_e( 'Max Orders', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
						<th><?php esc_html_e( 'Actions', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php $aicoso_pickup_time_slots = AICOSO_Pickup_Delivery_Data::get_pickup_time_slots(); ?>

					<?php if ( empty( $aicoso_pickup_time_slots ) ) : ?>
						<tr>
							<td colspan="5"><?php esc_html_e( 'No pickup time slots defined.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></td>
						</tr>
					<?php else : ?>
						<?php foreach ( $aicoso_pickup_time_slots as $aicoso_slot ) : ?>
							<tr class="time-slot-row" data-slot-type="pickup" data-slot-name="<?php echo esc_attr( $aicoso_slot['slot_name'] ); ?>" data-start-time="<?php echo esc_attr( $aicoso_slot['start_time'] ); ?>" data-end-time="<?php echo esc_attr( $aicoso_slot['end_time'] ); ?>" data-max-orders="<?php echo esc_attr( $aicoso_slot['max_orders'] ); ?>">
								<td><?php echo esc_html( $aicoso_slot['slot_name'] ); ?></td>
								<td><?php echo esc_html( AICOSO_Pickup_Delivery_Data::format_time( $aicoso_slot['start_time'] ) ); ?></td>
								<td><?php echo esc_html( AICOSO_Pickup_Delivery_Data::format_time( $aicoso_slot['end_time'] ) ); ?></td>
								<td><?php echo esc_html( $aicoso_slot['max_orders'] ); ?></td>
								<td>
									<button type="button" class="button button-small edit-time-slot" data-slot-type="pickup"><?php esc_html_e( 'Edit', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
									<button type="submit" name="delete_pickup_time_slot" value="<?php echo esc_attr( $aicoso_slot['slot_name'] ); ?>" class="button button-small"><?php esc_html_e( 'Delete', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
								</td>
							</tr>
						<?php endforeach; ?>
					<?php endif; ?>
				</tbody>
			</table>
			
			<h4 id="pickup-form-title"><?php esc_html_e( 'Add New Pickup Time Slot', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h4>
			
			<table class="form-table">
				<input type="hidden" id="edit_pickup_slot_original" name="edit_pickup_slot_original" value="" />
				<tr>
					<th scope="row">
						<label for="pickup_slot_name"><?php esc_html_e( 'Time Slot Name', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
					</th>
					<td>
						<input type="text" id="pickup_slot_name" name="pickup_slot_name" class="regular-text" placeholder="<?php esc_html_e( 'e.g., Morning (9:00 AM - 12:00 PM)', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>" />
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="pickup_start_time"><?php esc_html_e( 'Start Time', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
					</th>
					<td>
						<input type="time" id="pickup_start_time" name="pickup_start_time" class="regular-text" />
						<p class="description"><?php esc_html_e( 'The start time for this slot (24-hour format).', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="pickup_end_time"><?php esc_html_e( 'End Time', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
					</th>
					<td>
						<input type="time" id="pickup_end_time" name="pickup_end_time" class="regular-text" />
						<p class="description"><?php esc_html_e( 'The end time for this slot (24-hour format).', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="pickup_max_orders"><?php esc_html_e( 'Maximum Orders', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
					</th>
					<td>
						<input type="number" id="pickup_max_orders" name="pickup_max_orders" min="1" max="1000" value="10" class="regular-text" />
						<p class="description"><?php esc_html_e( 'The maximum number of pickup orders allowed for this time slot.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"></th>
					<td>
						<button type="submit" name="add_pickup_time_slot" id="add_pickup_button" class="button button-primary"><?php esc_html_e( 'Add Time Slot', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
						<button type="submit" name="update_pickup_time_slot" id="update_pickup_button" class="button button-primary" style="display:none;"><?php esc_html_e( 'Update Time Slot', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
						<button type="button" id="cancel_pickup_edit" class="button" style="display:none;"><?php esc_html_e( 'Cancel', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
					</td>
				</tr>
			</table>
		</div>

		<?php submit_button(); ?>