<?php
/**
 * Pickup Settings Admin Page Template
 *
 * This admin template allows store owners to configure pickup-related settings
 * for the WooCommerce "Aicoso Pickup & Delivery" plugin. It provides options to:
 * - Enable or disable pickup date selection
 * - Set maximum pickups allowed per day
 * - Define lead time for pickup orders
 * - Choose available pickup days of the week
 * - Manage blackout dates when pickup is unavailable
 *
 * @package    Aicoso_Pickup_Delivery_For_Woocommerce
 * @subpackage Admin/Templates
 * @author     Aicoso
 * @version    1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<h2><?php esc_html_e( 'Pickup Settings', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
<?php wp_nonce_field( 'aicoso_pickup_delivery_settings', 'aicoso_pickup_delivery_nonce' ); ?>
</h2>
		<p><?php esc_html_e( 'Configure the pickup options for your store.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
		
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="enable_pickup_date"><?php esc_html_e( 'Enable Pickup Date', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<div class="toggle-control">
						<label class="toggle-switch">
							<input type="checkbox" id="enable_pickup_date" name="enable_pickup_date" value="1" <?php checked( isset( $settings['enable_pickup_date'] ) && 'yes' === $settings['enable_pickup_date'] ); ?> />
							<span class="toggle-slider"></span>
						</label>
						<label for="enable_pickup_date" class="toggle-label">
							<?php esc_html_e( 'Allow customers to select a pickup date', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
						</label>
					</div>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="max_pickup_per_day"><?php esc_html_e( 'Maximum Pickups Per Day', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<input type="number" id="max_pickup_per_day" name="max_pickup_per_day" min="1" max="1000" value="<?php echo isset( $settings['max_pickup_per_day'] ) ? esc_attr( $settings['max_pickup_per_day'] ) : '25'; ?>" class="regular-text" />
					<p class="description"><?php esc_html_e( 'The maximum number of pickups allowed per day.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="pickup_lead_time"><?php esc_html_e( 'Pickup Lead Time', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<input type="number" id="pickup_lead_time" name="pickup_lead_time" min="0" max="30" value="<?php echo isset( $settings['pickup_lead_time'] ) ? esc_attr( $settings['pickup_lead_time'] ) : '1'; ?>" class="regular-text" />
					<p class="description"><?php esc_html_e( 'The minimum number of days in advance a pickup must be scheduled.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label><?php esc_html_e( 'Pickup Days', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<?php
					$days = array(
						1 => __( 'Monday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						2 => __( 'Tuesday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						3 => __( 'Wednesday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						4 => __( 'Thursday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						5 => __( 'Friday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						6 => __( 'Saturday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						7 => __( 'Sunday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					);

					$pickup_days = isset( $settings['pickup_days'] ) ? $settings['pickup_days'] : array( 1, 2, 3, 4, 5 );

					foreach ( $days as $day_num => $day_name ) :
						?>
						<label>
							<input type="checkbox" name="pickup_day_<?php echo esc_attr( $day_num ); ?>" value="1" <?php checked( in_array( $day_num, $pickup_days, true ) ); ?> />
							<?php echo esc_html( $day_name ); ?>
						</label><br>
					<?php endforeach; ?>
					<p class="description"><?php esc_html_e( 'Select the days of the week when pickup is available.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
		</table>
		
		<h3><?php esc_html_e( 'Blackout Dates', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h3>
		<p><?php esc_html_e( 'Add specific dates when pickup is not available.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
		
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="pickup_blackout_date"><?php esc_html_e( 'Add Blackout Date', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<input type="date" id="pickup_blackout_date" name="pickup_blackout_date" class="datepicker" pattern="\d{4}-\d{2}-\d{2}" />
					<button type="submit" name="add_pickup_blackout_date" class="button button-secondary"><?php esc_html_e( 'Add', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
					<p class="description"><?php esc_html_e( 'Add a date when pickup is not available (format: YYYY-MM-DD).', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Current Blackout Dates', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				<td>
					<?php $blackout_dates = AICOSO_Pickup_Delivery_Data::get_blackout_dates( 'pickup' ); ?>
					
					<?php if ( empty( $blackout_dates ) ) : ?>
						<p><?php esc_html_e( 'No blackout dates set.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
					<?php else : ?>
						<table class="widefat fixed striped">
							<thead>
								<tr>
									<th><?php esc_html_e( 'Date', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
									<th><?php esc_html_e( 'Formatted Date', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
									<th><?php esc_html_e( 'Actions', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
								</tr>
							</thead>
							<tbody>
								<?php foreach ( $blackout_dates as $date ) : ?>
									<tr>
										<td><?php echo esc_html( $date ); ?></td>
										<td><?php echo esc_html( AICOSO_Pickup_Delivery_Data::format_date( $date ) ); ?></td>
										<td>
											<button type="submit" name="remove_blackout_date" value="<?php echo esc_attr( $date ); ?>" class="button button-small"><?php esc_html_e( 'Remove', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
										</td>
									</tr>
								<?php endforeach; ?>
							</tbody>
						</table>
					<?php endif; ?>
				</td>
			</tr>
		</table>
		
		<?php submit_button(); ?>
