<?php
/**
 * Pickup Locations Admin Page Template
 *
 * This template handles the display and management of pickup locations
 * for the WooCommerce "Aicoso Pickup & Delivery" plugin.
 *
 * It allows admin users to:
 * - View existing pickup locations
 * - Add new pickup locations
 * - Edit or delete existing locations
 *
 * @package    Aicoso_Pickup_Delivery_For_Woocommerce
 * @subpackage Admin/Templates
 * @author     Aicoso
 * @version    1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<h2><?php esc_html_e( 'Pickup Locations', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
<?php wp_nonce_field( 'aicoso_pickup_delivery_settings', 'aicoso_pickup_delivery_nonce' ); ?>
</h2>
		<p><?php esc_html_e( 'Manage the pickup locations for your store.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
		
		<h3><?php esc_html_e( 'Current Pickup Locations', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h3>
		
		<table class="widefat fixed striped">
			<thead>
				<tr>
					<th><?php esc_html_e( 'Location Name', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Address', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Map URL', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Admin Email', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Max Orders', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Actions', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php $aicoso_pickup_locations = AICOSO_Pickup_Delivery_Data::get_pickup_locations(); ?>
				
				<?php if ( empty( $aicoso_pickup_locations ) ) : ?>
					<tr>
						<td colspan="6"><?php esc_html_e( 'No pickup locations defined.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></td>
					</tr>
				<?php else : ?>
					<?php foreach ( $aicoso_pickup_locations as $aicoso_location ) : ?>
						<tr>
							<td><?php echo esc_html( $aicoso_location['location_name'] ); ?></td>
							<td><?php echo esc_html( isset( $aicoso_location['location_address'] ) ? $aicoso_location['location_address'] : '' ); ?></td>
							<td>
								<?php if ( ! empty( $aicoso_location['location_map_url'] ) ) : ?>
									<a href="<?php echo esc_url( $aicoso_location['location_map_url'] ); ?>" target="_blank"><?php esc_html_e( 'View Map', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></a>
								<?php else : ?>
									<?php esc_html_e( 'No map URL', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
								<?php endif; ?>
							</td>
							<td><?php echo esc_html( isset( $aicoso_location['location_email'] ) ? $aicoso_location['location_email'] : '' ); ?></td>
							<td><?php echo esc_html( isset( $aicoso_location['max_orders'] ) ? $aicoso_location['max_orders'] : '25' ); ?></td>
							<td>
								<button type="submit" name="delete_pickup_location" value="<?php echo esc_attr( $aicoso_location['location_name'] ); ?>" class="button button-small"><?php esc_html_e( 'Delete', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
								<a href="#" class="button button-small edit-location" data-location="<?php echo esc_attr( wp_json_encode( $aicoso_location ) ); ?>"><?php esc_html_e( 'Edit', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></a>
							</td>
						</tr>
					<?php endforeach; ?>
				<?php endif; ?>
			</tbody>
		</table>
		
		<h3 id="location_form_title"><?php esc_html_e( 'Add New Pickup Location', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h3>
		
		<input type="hidden" id="location_action" name="location_action" value="add" />
		<input type="hidden" id="original_location_name" name="original_location_name" value="" />
		
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="location_name"><?php esc_html_e( 'Location Name', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?> <span class="required">*</span></label>
				</th>
				<td>
					<input type="text" id="location_name" name="location_name" class="regular-text"  />
					<p class="description"><?php esc_html_e( 'The name of this pickup location (e.g., Main Store, Downtown Branch).', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="location_address"><?php esc_html_e( 'Address', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<textarea id="location_address" name="location_address" class="regular-text" rows="3"></textarea>
					<p class="description"><?php esc_html_e( 'The full address of this pickup location.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="location_map_url"><?php esc_html_e( 'Google Maps URL', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<input type="url" id="location_map_url" name="location_map_url" class="regular-text" />
					<p class="description"><?php esc_html_e( 'A Google Maps URL to help customers find this location.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="location_email"><?php esc_html_e( 'Admin Email', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<input type="email" id="location_email" name="location_email" class="regular-text" value="<?php echo esc_attr( get_option( 'admin_email' ) ); ?>" />
					<p class="description"><?php esc_html_e( 'Email address to receive notifications for this pickup location.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="location_max_orders"><?php esc_html_e( 'Maximum Orders', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<input type="number" id="location_max_orders" name="location_max_orders" min="1" max="1000" value="25" class="regular-text" />
					<p class="description"><?php esc_html_e( 'The maximum number of pickup orders allowed for this location per day.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row"></th>
				<td>
					<button type="submit" id="location_submit_btn" name="add_pickup_location" class="button button-primary"><?php esc_html_e( 'Add Location', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
					<button type="button" id="location_cancel_btn" class="button button-secondary" style="display:none;"><?php esc_html_e( 'Cancel', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
				</td>
			</tr>
		</table>
		
		<?php submit_button(); ?>