<?php
/**
 * General Settings Admin Page for Pickup & Delivery Plugin
 *
 * This file handles the display and management of general settings
 * such as order type selection, default order type, max orders per day,
 * and data deletion on uninstall.
 *
 * @package    Aicoso_Pickup_Delivery_For_Woocommerce
 * @subpackage Admin
 * @author     aicoso
 * @since      1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<h2><?php esc_html_e( 'General Settings', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
<?php wp_nonce_field( 'aicoso_pickup_delivery_settings', 'aicoso_pickup_delivery_nonce' ); ?>
</h2>
		<p><?php esc_html_e( 'Configure the general settings for the pickup and delivery options.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
		
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="enable_order_type_selection"><?php esc_html_e( 'Order Type Selection', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<div class="toggle-control">
						<label class="toggle-switch">
							<input type="checkbox" id="enable_order_type_selection" name="enable_order_type_selection" value="1" <?php checked( isset( $settings['enable_order_type_selection'] ) && 'yes' === $settings['enable_order_type_selection'] ); ?> />
							<span class="toggle-slider"></span>
						</label>
						<label for="enable_order_type_selection" class="toggle-label">
							<?php esc_html_e( 'Allow customers to choose between delivery and pickup', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
						</label>
					</div>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="default_order_type"><?php esc_html_e( 'Default Order Type', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<select id="default_order_type" name="default_order_type">
						<option value="delivery" <?php selected( isset( $settings['default_order_type'] ) && 'delivery' === $settings['default_order_type'] ); ?>><?php esc_html_e( 'Delivery', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
						<option value="pickup" <?php selected( isset( $settings['default_order_type'] ) && 'pickup' === $settings['default_order_type'] ); ?>><?php esc_html_e( 'Pickup', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
					</select>
					<p class="description"><?php esc_html_e( 'The default order type to be selected on the checkout page.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="max_orders_per_day"><?php esc_html_e( 'Maximum Orders Per Day', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<input type="number" id="max_orders_per_day" name="max_orders_per_day" min="1" max="1000" value="<?php echo isset( $settings['max_orders_per_day'] ) ? esc_attr( $settings['max_orders_per_day'] ) : '50'; ?>" class="regular-text" />
					<p class="description"><?php esc_html_e( 'The maximum number of combined delivery and pickup orders allowed per day.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="delete_data_on_uninstall"><?php esc_html_e( 'Delete Data on Uninstall', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<label>
						<input type="checkbox" id="delete_data_on_uninstall" name="delete_data_on_uninstall" value="1" <?php checked( 'yes' === get_option( 'aicoso_pickup_delivery_delete_data_on_uninstall' ) ); ?> />
						<?php esc_html_e( 'Delete all plugin data when uninstalling the plugin', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
					</label>
					<p class="description"><?php esc_html_e( 'Warning: This will remove all settings and data when the plugin is uninstalled.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
		</table>
		
		<?php submit_button(); ?>
