<?php
/**
 * Email Notification Settings Admin Page for Pickup & Delivery Plugin.
 *
 * This file provides the admin interface for configuring email notification options
 * for delivery and pickup orders. It allows enabling/disabling emails for customers
 * and admins, viewing available templates, and testing email delivery.
 *
 * @package    Aicoso_Pickup_Delivery_For_Woocommerce
 * @subpackage Admin
 * @author     aicoso
 * @since      1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<h2><?php esc_html_e( 'Email Notification Settings', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
<?php wp_nonce_field( 'aicoso_pickup_delivery_settings', 'aicoso_pickup_delivery_nonce' ); ?>
</h2>
		<p><?php esc_html_e( 'Configure email notifications for delivery and pickup.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
		
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="enable_delivery_confirmation_email"><?php esc_html_e( 'Delivery Confirmation Email', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<div class="toggle-control">
						<label class="toggle-switch">
							<input type="checkbox" id="enable_delivery_confirmation_email" name="enable_delivery_confirmation_email" value="1" <?php checked( isset( $settings['enable_delivery_confirmation_email'] ) && 'yes' === $settings['enable_delivery_confirmation_email'] ); ?> />
							<span class="toggle-slider"></span>
						</label>
						<label for="enable_delivery_confirmation_email" class="toggle-label">
							<?php esc_html_e( 'Send a delivery confirmation email to customers', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
						</label>
					</div>
					<p class="description"><?php esc_html_e( 'This email includes delivery details and is sent after order processing.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="enable_pickup_confirmation_email"><?php esc_html_e( 'Pickup Confirmation Email', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<div class="toggle-control">
						<label class="toggle-switch">
							<input type="checkbox" id="enable_pickup_confirmation_email" name="enable_pickup_confirmation_email" value="1" <?php checked( isset( $settings['enable_pickup_confirmation_email'] ) && 'yes' === $settings['enable_pickup_confirmation_email'] ); ?> />
							<span class="toggle-slider"></span>
						</label>
						<label for="enable_pickup_confirmation_email" class="toggle-label">
							<?php esc_html_e( 'Send a pickup confirmation email to customers', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
						</label>
					</div>
					<p class="description"><?php esc_html_e( 'This email includes pickup details and is sent after order processing.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="enable_admin_notification_email"><?php esc_html_e( 'Admin Notification Email', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<div class="toggle-control">
						<label class="toggle-switch">
							<input type="checkbox" id="enable_admin_notification_email" name="enable_admin_notification_email" value="1" <?php checked( isset( $settings['enable_admin_notification_email'] ) && 'yes' === $settings['enable_admin_notification_email'] ); ?> />
							<span class="toggle-slider"></span>
						</label>
						<label for="enable_admin_notification_email" class="toggle-label">
							<?php esc_html_e( 'Send email notifications to administrators', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
						</label>
					</div>
					<p class="description"><?php esc_html_e( 'Notifications about new delivery/pickup orders and location-specific notifications.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
		</table>
		
		<h3><?php esc_html_e( 'Email Templates', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h3>
		<p><?php esc_html_e( 'You can customize email templates by copying the templates from the plugin "templates/emails" directory to your theme "woocommerce/emails" directory.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
		
		<table class="widefat" style="margin-top: 20px; margin-bottom: 20px;">
			<thead>
				<tr>
					<th><?php esc_html_e( 'Email', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Description', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Template Path', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td><?php esc_html_e( 'Delivery Confirmation', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></td>
					<td><?php esc_html_e( 'Sent to the customer when a delivery order is processed.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></td>
					<td><code>woocommerce/emails/delivery-confirmation.php</code></td>
				</tr>
				<tr>
					<td><?php esc_html_e( 'Pickup Confirmation', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></td>
					<td><?php esc_html_e( 'Sent to the customer when a pickup order is processed.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></td>
					<td><code>woocommerce/emails/pickup-confirmation.php</code></td>
				</tr>
				<tr>
					<td><?php esc_html_e( 'Admin Notification', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></td>
					<td><?php esc_html_e( 'Sent to admin when a new delivery or pickup order is placed.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></td>
					<td><code>woocommerce/emails/admin-new-delivery-pickup.php</code></td>
				</tr>
			</tbody>
		</table>
		
		<h3><?php esc_html_e( 'Email Content Settings', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h3>
		<p><?php esc_html_e( 'These settings are managed through the WooCommerce email settings. You can customize subject lines, email content, and other options there.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
		
		<p>
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=wc-settings&tab=email' ) ); ?>" class="button button-secondary">
				<?php esc_html_e( 'Go to WooCommerce Email Settings', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
			</a>
		</p>
		
		<h3><?php esc_html_e( 'Testing Emails', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h3>
		<p><?php esc_html_e( 'You can test the delivery and pickup notification emails using the buttons below. Test emails will be sent to the admin email address.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
		
		<p>
			<button type="submit" name="test_delivery_email" class="button button-secondary">
				<?php esc_html_e( 'Send Test Delivery Email', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
			</button>
			
			<button type="submit" name="test_pickup_email" class="button button-secondary" style="margin-left: 10px;">
				<?php esc_html_e( 'Send Test Pickup Email', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
			</button>
		</p>
		
		<?php submit_button(); ?>
