<?php
/**
 * Delivery Settings Admin Page for Pickup & Delivery Plugin.
 *
 * This file handles the display and configuration of delivery-related options
 * including delivery days, blackout dates, maximum deliveries per day, and lead time.
 *
 * @package    Aicoso_Pickup_Delivery_For_Woocommerce
 * @subpackage Admin
 * @author     aicoso
 * @since      1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<h2><?php esc_html_e( 'Delivery Settings', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
<?php wp_nonce_field( 'aicoso_pickup_delivery_settings', 'aicoso_pickup_delivery_nonce' ); ?>
</h2>
		<p><?php esc_html_e( 'Configure the delivery options for your store.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
		
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="enable_delivery_date"><?php esc_html_e( 'Enable Delivery Date', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<div class="toggle-control">
						<label class="toggle-switch">
							<input type="checkbox" id="enable_delivery_date" name="enable_delivery_date" value="1" <?php checked( isset( $settings['enable_delivery_date'] ) && 'yes' === $settings['enable_delivery_date'] ); ?> />
							<span class="toggle-slider"></span>
						</label>
						<label for="enable_delivery_date" class="toggle-label">
							<?php esc_html_e( 'Allow customers to select a delivery date', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?>
						</label>
					</div>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="max_delivery_per_day"><?php esc_html_e( 'Maximum Deliveries Per Day', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<input type="number" id="max_delivery_per_day" name="max_delivery_per_day" min="1" max="1000" value="<?php echo isset( $settings['max_delivery_per_day'] ) ? esc_attr( $settings['max_delivery_per_day'] ) : '25'; ?>" class="regular-text" />
					<p class="description"><?php esc_html_e( 'The maximum number of deliveries allowed per day.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="delivery_lead_time"><?php esc_html_e( 'Delivery Lead Time', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<input type="number" id="delivery_lead_time" name="delivery_lead_time" min="0" max="30" value="<?php echo isset( $settings['delivery_lead_time'] ) ? esc_attr( $settings['delivery_lead_time'] ) : '1'; ?>" class="regular-text" />
					<p class="description"><?php esc_html_e( 'The minimum number of days in advance a delivery must be scheduled.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label><?php esc_html_e( 'Delivery Days', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<?php
					$days = array(
						1 => __( 'Monday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						2 => __( 'Tuesday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						3 => __( 'Wednesday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						4 => __( 'Thursday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						5 => __( 'Friday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						6 => __( 'Saturday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						7 => __( 'Sunday', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					);

					$delivery_days = isset( $settings['delivery_days'] ) ? $settings['delivery_days'] : array( 1, 2, 3, 4, 5 );

					foreach ( $days as $day_num => $day_name ) :
						?>
						<label>
							<input type="checkbox" name="delivery_day_<?php echo esc_attr( $day_num ); ?>" value="1" <?php checked( in_array( $day_num, $delivery_days, true ) ); ?> />
							<?php echo esc_html( $day_name ); ?>
						</label><br>
					<?php endforeach; ?>
					<p class="description"><?php esc_html_e( 'Select the days of the week when delivery is available.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
		</table>
		
		<h3><?php esc_html_e( 'Blackout Dates', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h3>
		<p><?php esc_html_e( 'Add specific dates when delivery is not available.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
		
		<table class="form-table">
			<tr>
				<th scope="row">
					<label for="delivery_blackout_date"><?php esc_html_e( 'Add Blackout Date', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
				</th>
				<td>
					<input type="date" id="delivery_blackout_date" name="delivery_blackout_date" class="datepicker" pattern="\d{4}-\d{2}-\d{2}" />
					<button type="submit" name="add_delivery_blackout_date" class="button button-secondary"><?php esc_html_e( 'Add', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
					<p class="description"><?php esc_html_e( 'Add a date when delivery is not available (format: YYYY-MM-DD).', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Current Blackout Dates', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
				<td>
					<?php $blackout_dates = AICOSO_Pickup_Delivery_Data::get_blackout_dates( 'delivery' ); ?>
					
					<?php if ( empty( $blackout_dates ) ) : ?>
						<p><?php esc_html_e( 'No blackout dates set.', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></p>
					<?php else : ?>
						<table class="widefat fixed striped">
							<thead>
								<tr>
									<th><?php esc_html_e( 'Date', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
									<th><?php esc_html_e( 'Formatted Date', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
									<th><?php esc_html_e( 'Actions', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></th>
								</tr>
							</thead>
							<tbody>
								<?php foreach ( $blackout_dates as $date ) : ?>
									<tr>
										<td><?php echo esc_html( $date ); ?></td>
										<td><?php echo esc_html( AICOSO_Pickup_Delivery_Data::format_date( $date ) ); ?></td>
										<td>
											<button type="submit" name="remove_blackout_date" value="<?php echo esc_attr( $date ); ?>" class="button button-small"><?php esc_html_e( 'Remove', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></button>
										</td>
									</tr>
								<?php endforeach; ?>
							</tbody>
						</table>
					<?php endif; ?>
				</td>
			</tr>
		</table>
		
		<?php submit_button(); ?>
