<?php
/**
 * Order meta box for delivery/pickup details.
 *
 * @package    Aicoso_Pickup_Delivery_For_Woocommerce
 * @version    1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// Get settings.
$settings = AICOSO_Pickup_Delivery_Data::get_settings();

// Get delivery details.
$delivery_date = $order->get_meta( '_aicoso_pickup_delivery_delivery_date', true );
$delivery_time = $order->get_meta( '_aicoso_pickup_delivery_delivery_time_slot', true );

// Get pickup details.
$pickup_date     = $order->get_meta( '_aicoso_pickup_delivery_pickup_date', true );
$pickup_time     = $order->get_meta( '_aicoso_pickup_delivery_pickup_time_slot', true );
$pickup_location = $order->get_meta( '_aicoso_pickup_delivery_pickup_location', true );

// Get delivery time slots.
$aicoso_delivery_time_slots   = AICOSO_Pickup_Delivery_Data::get_delivery_time_slots();
$aicoso_delivery_slot_options = array();
foreach ( $aicoso_delivery_time_slots as $aicoso_slot ) {
	$aicoso_delivery_slot_options[ $aicoso_slot['slot_name'] ] = $aicoso_slot['slot_name'];
}

// Get pickup time slots.
$aicoso_pickup_time_slots   = AICOSO_Pickup_Delivery_Data::get_pickup_time_slots();
$aicoso_pickup_slot_options = array();
foreach ( $aicoso_pickup_time_slots as $aicoso_slot ) {
	$aicoso_pickup_slot_options[ $aicoso_slot['slot_name'] ] = $aicoso_slot['slot_name'];
}

// Get pickup locations.
$aicoso_pickup_locations = AICOSO_Pickup_Delivery_Data::get_pickup_locations();
$aicoso_location_options = array();
foreach ( $aicoso_pickup_locations as $aicoso_location ) {
	$aicoso_location_options[ $aicoso_location['location_name'] ] = $aicoso_location['location_name'];
}
?>

<div class="aicoso-pickup-delivery-order-meta" style="background: #f8f9fa; padding: 12px; border-left: 4px solid #7f54b3; margin: 15px 0;">
	<h4 style="margin-top: 0; color: #7f54b3;"><?php esc_html_e( '📦 Delivery / Pickup Information', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></h4>

	<?php if ( 'delivery' === $order_type && ( $delivery_date || $delivery_time ) ) : ?>
		<div style="background: white; padding: 10px; border-radius: 4px; margin-bottom: 10px;">
			<strong style="color: #2271b1;"><?php esc_html_e( 'Current Delivery Details:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></strong>
			<?php if ( $delivery_date ) : ?>
				<div style="margin-top: 5px;">📅 <?php esc_html_e( 'Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?> <strong><?php echo esc_html( AICOSO_Pickup_Delivery_Data::format_date( $delivery_date ) ); ?></strong></div>
			<?php endif; ?>
			<?php if ( $delivery_time ) : ?>
				<div style="margin-top: 5px;">🕐 <?php esc_html_e( 'Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?> <strong><?php echo esc_html( $delivery_time ); ?></strong></div>
			<?php endif; ?>
		</div>
	<?php elseif ( 'pickup' === $order_type && ( $pickup_date || $pickup_time || $pickup_location ) ) : ?>
		<div style="background: white; padding: 10px; border-radius: 4px; margin-bottom: 10px;">
			<strong style="color: #2271b1;"><?php esc_html_e( 'Current Pickup Details:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></strong>
			<?php if ( $pickup_date ) : ?>
				<div style="margin-top: 5px;">📅 <?php esc_html_e( 'Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?> <strong><?php echo esc_html( AICOSO_Pickup_Delivery_Data::format_date( $pickup_date ) ); ?></strong></div>
			<?php endif; ?>
			<?php if ( $pickup_time ) : ?>
				<div style="margin-top: 5px;">🕐 <?php esc_html_e( 'Time:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?> <strong><?php echo esc_html( $pickup_time ); ?></strong></div>
			<?php endif; ?>
			<?php if ( $pickup_location ) : ?>
				<div style="margin-top: 5px;">📍 <?php esc_html_e( 'Location:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?> <strong><?php echo esc_html( $pickup_location ); ?></strong></div>
			<?php endif; ?>
		</div>
	<?php endif; ?>
	
	<p>
		<label for="aicoso_pickup_delivery_type"><strong><?php esc_html_e( 'Order Type:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></strong></label>
		<select id="aicoso_pickup_delivery_type" name="aicoso_pickup_delivery_type" class="wc-enhanced-select" style="width: 100%;">
			<option value="delivery" <?php selected( $order_type, 'delivery' ); ?>><?php esc_html_e( 'Delivery', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
			<option value="pickup" <?php selected( $order_type, 'pickup' ); ?>><?php esc_html_e( 'Pickup', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
		</select>
	</p>

	<div class="aicoso-pickup-delivery-delivery-fields" <?php echo 'delivery' !== $order_type ? 'style="display:none;"' : ''; ?>>
		<p>
			<label for="aicoso_pickup_delivery_delivery_date"><?php esc_html_e( 'Delivery Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
			<input type="text" id="aicoso_pickup_delivery_delivery_date" name="aicoso_pickup_delivery_delivery_date" class="date-picker" value="<?php echo esc_attr( $delivery_date ); ?>" placeholder="YYYY-MM-DD" />
		</p>
		
		<p>
			<label for="aicoso_pickup_delivery_delivery_time_slot"><?php esc_html_e( 'Delivery Time Slot:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
			<select id="aicoso_pickup_delivery_delivery_time_slot" name="aicoso_pickup_delivery_delivery_time_slot" class="wc-enhanced-select">
				<option value=""><?php esc_html_e( 'Select a time slot', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
				<?php foreach ( $aicoso_delivery_slot_options as $value => $label ) : ?>
					<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $delivery_time, $value ); ?>><?php echo esc_html( $label ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
	</div>

	<div class="aicoso-pickup-delivery-pickup-fields" <?php echo 'pickup' !== $order_type ? 'style="display:none;"' : ''; ?>>
		<p>
			<label for="aicoso_pickup_delivery_pickup_date"><?php esc_html_e( 'Pickup Date:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
			<input type="text" id="aicoso_pickup_delivery_pickup_date" name="aicoso_pickup_delivery_pickup_date" class="date-picker" value="<?php echo esc_attr( $pickup_date ); ?>" placeholder="YYYY-MM-DD" />
		</p>
		
		<p>
			<label for="aicoso_pickup_delivery_pickup_time_slot"><?php esc_html_e( 'Pickup Time Slot:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
			<select id="aicoso_pickup_delivery_pickup_time_slot" name="aicoso_pickup_delivery_pickup_time_slot" class="wc-enhanced-select">
				<option value=""><?php esc_html_e( 'Select a time slot', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
				<?php foreach ( $aicoso_pickup_slot_options as $value => $label ) : ?>
					<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $pickup_time, $value ); ?>><?php echo esc_html( $label ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
		
		<p>
			<label for="aicoso_pickup_delivery_pickup_location"><?php esc_html_e( 'Pickup Location:', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></label>
			<select id="aicoso_pickup_delivery_pickup_location" name="aicoso_pickup_delivery_pickup_location" class="wc-enhanced-select">
				<option value=""><?php esc_html_e( 'Select a location', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
				<?php foreach ( $aicoso_location_options as $value => $label ) : ?>
					<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $pickup_location, $value ); ?>><?php echo esc_html( $label ); ?></option>
				<?php endforeach; ?>
			</select>
		</p>
	</div>
	
	<?php wp_nonce_field( 'aicoso_pickup_delivery_save_order_meta', 'aicoso_pickup_delivery_nonce' ); ?>
	<input type="hidden" name="aicoso_pickup_delivery_order_update" value="1" />
</div>