<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    aicoso_pickup_delivery
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and hooks for the admin area.
 *
 * @package    aicoso_pickup_delivery
 * @author     Your Name
 */
class AICOSO_Pickup_Delivery_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param    string $plugin_name       The name of this plugin.
	 * @param    string $version           The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {
		$screen = get_current_screen();

		// Only enqueue on our plugin pages or WooCommerce order pages.
		if ( false !== strpos( $screen->id, 'aicoso-pickup-delivery' ) || 'shop_order' === $screen->id || false !== strpos( $screen->id, 'aicoso-pickup-and-delivery-for-woocommerce' ) ) {
			// Use local jQuery UI CSS instead of CDN to comply with WordPress plugin guidelines.
			wp_enqueue_style( 'jquery-ui-style', plugin_dir_url( dirname( __DIR__, 1 ) ) . 'assets/css/jquery-ui.min.css', array(), '1.12.1' );
			wp_enqueue_style( $this->plugin_name, plugin_dir_url( dirname( __DIR__, 1 ) ) . 'assets/css/aicoso-pickup-delivery-admin.css', array(), $this->version, 'all' );
		}
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {
		$screen = get_current_screen();

		// Only enqueue on our plugin pages or WooCommerce order pages.
		if ( false !== strpos( $screen->id, 'aicoso-pickup-delivery' ) || 'shop_order' === $screen->id || false !== strpos( $screen->id, 'aicoso-pickup-and-delivery-for-woocommerce' ) ) {
			wp_enqueue_script( 'jquery-ui-datepicker' );
			wp_enqueue_script( $this->plugin_name, plugin_dir_url( dirname( __DIR__, 1 ) ) . 'assets/js/aicoso-pickup-delivery-admin.min.js', array( 'jquery', 'jquery-ui-datepicker' ), $this->version, false );

			// Enqueue order management JavaScript (moved from inline script for WordPress standards compliance).
			if ( 'shop_order' === $screen->id ) {
				wp_enqueue_script(
					$this->plugin_name . '-orders',
					plugin_dir_url( dirname( __DIR__, 1 ) ) . 'assets/js/aicoso-pickup-delivery-admin-orders.js',
					array( 'jquery', 'jquery-ui-datepicker' ),
					$this->version,
					true
				);
			}

			// Localized script data for admin.
			wp_localize_script(
				$this->plugin_name,
				'aicoso_pickup_delivery_admin',
				array(
					'ajax_url' => admin_url( 'admin-ajax.php' ),
					'nonce'    => wp_create_nonce( 'aicoso_pickup_delivery_admin_nonce' ),
					'i18n'     => array(
						'confirm_delete' => __( 'Are you sure you want to delete this item?', 'aicoso-pickup-and-delivery-for-woocommerce' ),
						'date_format'    => __( 'YYYY-MM-DD', 'aicoso-pickup-and-delivery-for-woocommerce' ),
					),
				)
			);
		}
	}

	/**
	 * Add a settings link to the plugins page
	 *
	 * @since    1.0.0
	 * @param    array $links    Plugin action links.
	 * @return   array              Modified action links
	 */
	public function add_plugin_links( $links ) {
		$plugin_links = array(
			'<a href="' . admin_url( 'admin.php?page=aicoso-pickup-delivery-settings' ) . '">' . __( 'Settings', 'aicoso-pickup-and-delivery-for-woocommerce' ) . '</a>',
		);

		return array_merge( $plugin_links, $links );
	}

	/**
	 * Add custom order status filter for pickup and delivery
	 *
	 * @since    1.0.0
	 * @param    array $request    Current request parameters.
	 * @return   array                Modified request parameters
	 */
	public function filter_orders_by_delivery_pickup( $request ) {
		global $pagenow, $typenow;

		// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Admin page filtering.
		if ( 'shop_order' === $typenow && 'edit.php' === $pagenow && isset( $_GET['order_type'] ) ) {
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Admin page filtering.
			$order_type = sanitize_text_field( wp_unslash( $_GET['order_type'] ) );

			if ( in_array( $order_type, array( 'delivery', 'pickup' ), true ) ) {
			// phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key,WordPress.DB.SlowDBQuery.slow_db_query_meta_value
				$request['meta_key'] = '_aicoso_pickup_delivery_type';
			// phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key,WordPress.DB.SlowDBQuery.slow_db_query_meta_value
				$request['meta_value'] = $order_type;
			}
		}

		return $request;
	}

	/**
	 * Add delivery/pickup filter to orders screen
	 *
	 * @since    1.0.0
	 */
	public function add_order_type_filter() {
		global $pagenow, $typenow;

		if ( 'shop_order' === $typenow && 'edit.php' === $pagenow ) {
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Admin page filtering.
			$current = isset( $_GET['order_type'] ) ? sanitize_text_field( wp_unslash( $_GET['order_type'] ) ) : '';
			?>
			<select name="order_type">
				<option value=""><?php esc_html_e( 'All order types', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
				<option value="delivery" <?php selected( $current, 'delivery' ); ?>><?php esc_html_e( 'Delivery Orders', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
				<option value="pickup" <?php selected( $current, 'pickup' ); ?>><?php esc_html_e( 'Pickup Orders', 'aicoso-pickup-and-delivery-for-woocommerce' ); ?></option>
			</select>
			<?php
		}
	}
}